/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.utils;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FSDataInputStream;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;

public class DataFileReader {
    private static final Logger LOG = Logger.getLogger(DataFileReader.class.getName());
    private final Config config;
    private final String fileSystem;
    private volatile FSDataInputStream fdis;

    public DataFileReader(Config cfg, String fileSys) {
        this.config = cfg;
        this.fileSystem = fileSys;
    }

    public double[][] readData(Path path, int dimension, int datasize) {
        double[][] datapoints = new double[datasize][dimension];
        try {
            String line;
            FileSystem fs = FileSystemUtils.get(path, this.config);
            if ("hdfs".equals(this.fileSystem)) {
                FileStatus pathFile = fs.getFileStatus(path);
                this.fdis = fs.open(pathFile.getPath());
            } else {
                for (FileStatus file : fs.listFiles(path)) {
                    this.fdis = fs.open(file.getPath());
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.fdis));
            int value = 0;
            while ((line = bufferedReader.readLine()) != null) {
                String[] data = line.split(",");
                for (int i = 0; i < data.length - 1; ++i) {
                    datapoints[value][i] = Double.parseDouble(data[i].trim());
                    datapoints[value][i + 1] = Double.parseDouble(data[i + 1].trim());
                }
                ++value;
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO Exception Occured");
        }
        return datapoints;
    }
}

