/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.utils;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.IDataNodeLocatorUtils;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import edu.iu.dsc.tws.data.utils.HdfsDataContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DataNodeLocatorUtils
implements IDataNodeLocatorUtils {
    private static final Logger LOG = Logger.getLogger(DataNodeLocatorUtils.class.getName());
    private Config config;
    private String datasetName;

    public DataNodeLocatorUtils(Config cfg) {
        this.config = cfg;
    }

    @Override
    public List<String> findDataNodesLocation(List<String> inputFileList) {
        List<String> dataNodes = new ArrayList<String>();
        try {
            for (String anInputFileList : inputFileList) {
                FileStatus fileStatus;
                Path path = new Path(anInputFileList);
                FileSystem fileSystem = FileSystemUtils.get(path.toUri(), this.config);
                this.datasetName = anInputFileList;
                if (this.config.get("filesys").equals("hdfs")) {
                    fileStatus = fileSystem.getFileStatus(new Path(this.datasetName));
                    if (fileStatus.getPath().isNullOrEmpty()) continue;
                    dataNodes = this.getDataNodes();
                    continue;
                }
                if (!this.config.get("filesys").equals("local") || (fileStatus = fileSystem.getFileStatus(new Path(this.datasetName))).getPath().isNullOrEmpty()) continue;
                String datanodeName = InetAddress.getLocalHost().getHostName();
                dataNodes.add(datanodeName);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException Occured");
        }
        return dataNodes;
    }

    @Override
    public List<String> findDataNodesLocation(String inputFileName) {
        List<String> dataNodes = new ArrayList<String>();
        try {
            FileStatus fileStatus;
            Path path = new Path(inputFileName);
            FileSystem fileSystem = FileSystemUtils.get(path.toUri(), this.config);
            if (this.config.get("filesys").equals("hdfs")) {
                FileStatus fileStatus2 = fileSystem.getFileStatus(path);
                if (!fileStatus2.getPath().isNullOrEmpty()) {
                    dataNodes = this.getDataNodes();
                }
            } else if (this.config.get("filesys").equals("local") && !(fileStatus = fileSystem.getFileStatus(path)).getPath().isNullOrEmpty()) {
                String datanodeName = InetAddress.getLocalHost().getHostName();
                dataNodes.add(datanodeName);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException Occured");
        }
        return dataNodes;
    }

    private List<String> getDataNodes() throws IOException {
        DatanodeInfo[] datanodeReport;
        Configuration conf = new Configuration(false);
        conf.addResource(new org.apache.hadoop.fs.Path(HdfsDataContext.getHdfsConfigDirectory(this.config)));
        ArrayList<String> datanodesList = new ArrayList<String>();
        InetSocketAddress namenodeAddress = new InetSocketAddress(HdfsDataContext.getHdfsNamenodeDefault(this.config), (int)HdfsDataContext.getHdfsNamenodePortDefault(this.config));
        DFSClient dfsClient = new DFSClient(namenodeAddress, conf);
        ClientProtocol nameNode = dfsClient.getNamenode();
        for (DatanodeInfo di : datanodeReport = nameNode.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL)) {
            datanodesList.add(di.getHostName());
        }
        return datanodesList;
    }

    private List<String> getDataNodes(String[] fName) throws IOException {
        DatanodeInfo[] datanodeReport;
        Configuration conf = new Configuration(false);
        conf.addResource(new org.apache.hadoop.fs.Path(HdfsDataContext.getHdfsConfigDirectory(this.config)));
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        ArrayList<String> datanodesList = new ArrayList<String>();
        InetSocketAddress namenodeAddress = new InetSocketAddress(HdfsDataContext.getHdfsNamenodeDefault(this.config), (int)HdfsDataContext.getHdfsNamenodePortDefault(this.config));
        DFSClient dfsClient = new DFSClient(namenodeAddress, conf);
        ClientProtocol nameNode = dfsClient.getNamenode();
        for (DatanodeInfo di : datanodeReport = nameNode.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL)) {
            datanodesList.add(di.getHostName());
        }
        try {
            ToolRunner.run((Tool)new DFSck(conf, out), (String[])fName);
            out.println();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception Occured:" + e.getMessage());
        }
        bStream.close();
        out.close();
        return datanodesList;
    }
}

