/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.utils;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.fs.local.LocalFileSystem;
import edu.iu.dsc.tws.data.hdfs.HadoopFileSystem;
import edu.iu.dsc.tws.data.utils.HdfsDataContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;

public final class FileSystemUtils {
    private static final Logger LOG = Logger.getLogger(FileSystemUtils.class.getName());
    private static final Object SYNCHRONIZATION_OBJECT = new Object();
    private static final Map<String, String> SUPPORTEDFS = new HashMap<String, String>();
    private static URI defaultScheme;
    private static String directoryString;

    private FileSystemUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystem getFileSystem(URI uri, Config config) throws IOException {
        FileSystem fs = null;
        URI asked = uri;
        URI curUri = uri;
        if (curUri == null) {
            throw new IOException("The URI " + curUri.toString() + " is not a vaild URI");
        }
        Object object = SYNCHRONIZATION_OBJECT;
        synchronized (object) {
            if (curUri.getScheme() == null) {
                try {
                    if (defaultScheme == null) {
                        defaultScheme = new URI("file:///");
                    }
                    curUri = new URI(defaultScheme.getScheme(), null, defaultScheme.getHost(), defaultScheme.getPort(), curUri.getPath(), null, null);
                }
                catch (URISyntaxException e) {
                    try {
                        if (defaultScheme.getScheme().equals("file")) {
                            curUri = new URI("file", null, new Path(new File(curUri.getPath()).getAbsolutePath()).toUri().getPath(), null);
                        }
                    }
                    catch (URISyntaxException ex) {
                        throw new IOException("The URI '" + curUri.toString() + "' is not valid.");
                    }
                }
            }
            if (curUri.getScheme() == null) {
                throw new IOException("The URI '" + curUri + "' is invalid.\nThe fs.default-scheme = " + defaultScheme + ", the requested URI = " + asked + ", and the final URI = " + curUri + ".");
            }
            if (curUri.getScheme().equals("file") && curUri.getAuthority() != null && !curUri.getAuthority().isEmpty()) {
                String supposedUri = "file:///" + curUri.getAuthority() + curUri.getPath();
                throw new IOException("Found local file path with authority '" + curUri.getAuthority() + "' in path '" + curUri.toString() + "'. Hint: Did you forget a slash? (correct path would be '" + supposedUri + "')");
            }
            if (FileSystemUtils.isSupportedScheme(curUri.getScheme())) {
                String fsClass = SUPPORTEDFS.get(curUri.getScheme());
                if ("hdfs".equals(curUri.getScheme())) {
                    try {
                        fs = FileSystemUtils.instantiateFileSystem(fsClass, config);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("No such method to invoke", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Invocation exception occured", e);
                    }
                    fs.initialize(curUri);
                } else {
                    fs = FileSystemUtils.instantiateFileSystem(fsClass);
                    fs.initialize(curUri);
                }
            }
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystem getFileSystem(URI uri) throws IOException {
        FileSystem fs = null;
        URI asked = uri;
        URI curUri = uri;
        if (curUri == null) {
            throw new IOException("The URI " + curUri.toString() + " is not a vaild URI");
        }
        Object object = SYNCHRONIZATION_OBJECT;
        synchronized (object) {
            if (curUri.getScheme() == null) {
                try {
                    if (defaultScheme == null) {
                        defaultScheme = new URI("file:///");
                    }
                    curUri = new URI(defaultScheme.getScheme(), null, defaultScheme.getHost(), defaultScheme.getPort(), curUri.getPath(), null, null);
                }
                catch (URISyntaxException e) {
                    try {
                        if (defaultScheme.getScheme().equals("file")) {
                            curUri = new URI("file", null, new Path(new File(curUri.getPath()).getAbsolutePath()).toUri().getPath(), null);
                        }
                    }
                    catch (URISyntaxException ex) {
                        throw new IOException("The URI '" + curUri.toString() + "' is not valid.");
                    }
                }
            }
            if (curUri.getScheme() == null) {
                throw new IOException("The URI '" + curUri + "' is invalid.\nThe fs.default-scheme = " + defaultScheme + ", the requested URI = " + asked + ", and the final URI = " + curUri + ".");
            }
            if (curUri.getScheme().equals("file") && curUri.getAuthority() != null && !curUri.getAuthority().isEmpty()) {
                String supposedUri = "file:///" + curUri.getAuthority() + curUri.getPath();
                throw new IOException("Found local file path with authority '" + curUri.getAuthority() + "' in path '" + curUri.toString() + "'. Hint: Did you forget a slash? (correct path would be '" + supposedUri + "')");
            }
            if (FileSystemUtils.isSupportedScheme(curUri.getScheme())) {
                String fsClass = SUPPORTEDFS.get(curUri.getScheme());
                fs = FileSystemUtils.instantiateFileSystem(fsClass);
                fs.initialize(curUri);
            }
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultScheme(Config config) throws IOException {
        Object object = SYNCHRONIZATION_OBJECT;
        synchronized (object) {
            if (defaultScheme == null) {
                String stringifiedUri = config.getStringValue("fs.default-scheme", "file:///");
                try {
                    defaultScheme = new URI(stringifiedUri);
                }
                catch (URISyntaxException e) {
                    throw new IOException("The URI used to set the default filesystem scheme ('" + stringifiedUri + "') is not valid.");
                }
            }
        }
    }

    public static FileSystem get(URI uri) throws IOException {
        return FileSystemUtils.getFileSystem(uri);
    }

    public static FileSystem get(Path path) throws IOException {
        return FileSystemUtils.getFileSystem(path.toUri());
    }

    public static FileSystem get(Path path, Config config) throws IOException {
        return FileSystemUtils.getFileSystem(path.toUri(), config);
    }

    public static FileSystem get(URI uri, Config config) throws IOException {
        return FileSystemUtils.getFileSystem(uri, config);
    }

    private static Class<? extends FileSystem> getFileSystemByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, FileSystem.class.getClassLoader()).asSubclass(FileSystem.class);
    }

    private static FileSystem instantiateFileSystem(String className) throws IOException {
        try {
            Class<? extends FileSystem> fsClass = FileSystemUtils.getFileSystemByName(className);
            return fsClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not load file system class '" + className + '\'', e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException("Could not instantiate file system class: " + e.getMessage(), e);
        }
    }

    private static FileSystem instantiateFileSystem(String className, Config config) throws IOException, NoSuchMethodException, InvocationTargetException {
        Object newInstance;
        try {
            Configuration conf = new Configuration(true);
            conf.addResource(new org.apache.hadoop.fs.Path(HdfsDataContext.getHdfsConfigDirectory(config)));
            conf.addResource(new org.apache.hadoop.fs.Path(HdfsDataContext.getHdfsDataDirectory(config)));
            conf.set("fs.defaultFS", FileSystemUtils.getHdfsURL(config));
            Class<?> fileSystemClass = ClassLoader.getSystemClassLoader().loadClass(className);
            Constructor<?> classConstructor = fileSystemClass.getConstructor(Configuration.class, org.apache.hadoop.fs.FileSystem.class);
            newInstance = classConstructor.newInstance(conf, org.apache.hadoop.fs.FileSystem.get((Configuration)conf));
        }
        catch (InstantiationException e) {
            throw new IOException("instantiation exception occured:" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not load file system class '" + className + '\'', e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Illegal access exception: " + e.getMessage(), e);
        }
        return (FileSystem)newInstance;
    }

    private static String getHdfsURL(Config config) {
        directoryString = "hdfs://" + HdfsDataContext.getHdfsNamenodeDefault(config) + ":" + HdfsDataContext.getHdfsNamenodePortDefault(config);
        return directoryString;
    }

    private static boolean isSupportedScheme(String scheme) {
        return SUPPORTEDFS.containsKey(scheme);
    }

    static {
        SUPPORTEDFS.put("file", LocalFileSystem.class.getName());
        SUPPORTEDFS.put("hdfs", HadoopFileSystem.class.getName());
    }
}

