/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.utils;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.TokenSub;
import java.util.Map;

public final class HdfsDataContext
extends Context {
    private static final String TWISTER2_DATA_HADOOP_HOME = "twister2.data.hadoop.home";
    private static final String TWISTER2_DATA_HADOOP_HOME_DEFAULT = "${HADOOP_HOME}";
    private static final String TWISTER2_DATA_HDFS_CONFIG_DIRECTORY = "twister2.data.hdfs.config.directory";
    private static final String TWISTER2_DATA_HDFS_CONFIG_DIRECTORY_DEFAULT = "$HADOOP_HOME/etc/hadoop/core-site.xml";
    private static final String TWISTER2_DATA_HDFS_DATA_DIRECTORY = "twister2.data.hdfs.data.directory";
    private static final String TWISTER2_DATA_HDFS_DATA_DIRECTORY_DEFAULT = "$HADOOP_HOME/etc/hadoop/hdfs-site.xml";
    private static final String TWISTER2_DATA_HDFS_NAMENODE = "twister2.data.hdfs.namenode";
    private static final String TWISTER2_DATA_HDFS_NAMENODE_DEFAULT = "hostname.domain.name";
    private static final String TWISTER2_DATA_HDFS_NAMENODE_PORT = "twister2.data.hdfs.namenode.port";
    private static final Integer TWISTER2_DATA_NAMENODE_PORT_DEFAULT = 9000;

    private HdfsDataContext() {
    }

    public static String getHdfsNamenodeDefault(Config cfg) {
        return cfg.getStringValue(TWISTER2_DATA_HDFS_NAMENODE, TWISTER2_DATA_HDFS_NAMENODE_DEFAULT);
    }

    public static Integer getHdfsNamenodePortDefault(Config cfg) {
        return cfg.getIntegerValue(TWISTER2_DATA_HDFS_NAMENODE_PORT, TWISTER2_DATA_NAMENODE_PORT_DEFAULT.intValue());
    }

    public static String getHdfsConfigDirectory(Config config) {
        return config.getStringValue(TWISTER2_DATA_HDFS_CONFIG_DIRECTORY, TWISTER2_DATA_HDFS_CONFIG_DIRECTORY_DEFAULT);
    }

    public static String getHdfsDataDirectory(Config config) {
        return config.getStringValue(TWISTER2_DATA_HDFS_DATA_DIRECTORY, TWISTER2_DATA_HDFS_DATA_DIRECTORY_DEFAULT);
    }

    public static String getHadoopHome(Config config) {
        return TokenSub.substitute((Config)config, (String)config.getStringValue(TWISTER2_DATA_HADOOP_HOME, TWISTER2_DATA_HADOOP_HOME_DEFAULT), (Map)Context.substitutions);
    }
}

