/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.utils;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.data.hdfs.HadoopFileSystem;
import edu.iu.dsc.tws.data.utils.HdfsDataContext;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsUtils {
    private static final Logger LOG = Logger.getLogger(HdfsUtils.class.getName());
    private Config config;
    private String fileName;
    private String directoryString;

    public HdfsUtils(Config cfg, String fName) {
        this.config = cfg;
        this.fileName = fName;
    }

    public HadoopFileSystem createHDFSFileSystem() {
        HadoopFileSystem hadoopFileSystem;
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(HdfsDataContext.getHdfsConfigDirectory(this.config)));
        conf.addResource(new Path(HdfsDataContext.getHdfsDataDirectory(this.config)));
        conf.set("fs.defaultFS", this.getHdfsURL());
        try {
            hadoopFileSystem = new HadoopFileSystem(conf, FileSystem.get((Configuration)conf));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Hadoop File System Creation Error:", ioe);
        }
        return hadoopFileSystem;
    }

    private String getHdfsURL() {
        this.directoryString = "hdfs:/" + HdfsDataContext.getHdfsNamenodeDefault(this.config) + HdfsDataContext.getHdfsNamenodeDefault(this.config) + "/" + this.fileName;
        return this.directoryString;
    }

    public edu.iu.dsc.tws.api.data.Path getPath() {
        edu.iu.dsc.tws.api.data.Path path = new edu.iu.dsc.tws.api.data.Path(this.directoryString);
        return path;
    }
}

