/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.utils;

public enum OperatingSystem {
    LINUX,
    WINDOWS,
    MACOS,
    UNKNOWN;

    private static final OperatingSystem OS;
    private static final String OS_KEY = "os.name";
    private static final String LINUX_OS_PREFIX = "Linux";
    private static final String WINDOWS_OS_PREFIX = "Windows";
    private static final String MAC_OS_PREFIX = "Mac";

    public static OperatingSystem getCurrentOperatingSystem() {
        return OS;
    }

    private static OperatingSystem readOSFromSystemProperties() {
        String osName = System.getProperty(OS_KEY);
        if (osName.startsWith(LINUX_OS_PREFIX)) {
            return LINUX;
        }
        if (osName.startsWith(WINDOWS_OS_PREFIX)) {
            return WINDOWS;
        }
        if (osName.startsWith(MAC_OS_PREFIX)) {
            return MACOS;
        }
        return UNKNOWN;
    }

    public static boolean isWindows() {
        return OperatingSystem.getCurrentOperatingSystem() == WINDOWS;
    }

    public static boolean isLinux() {
        return OperatingSystem.getCurrentOperatingSystem() == LINUX;
    }

    public static boolean isMac() {
        return OperatingSystem.getCurrentOperatingSystem() == MACOS;
    }

    static {
        OS = OperatingSystem.readOSFromSystemProperties();
    }
}

