/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.dataset;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.dataset.DataObject;
import edu.iu.dsc.tws.api.dataset.DataPartition;
import java.util.HashMap;
import java.util.Map;

public class DataObjectImpl<T>
implements DataObject<T> {
    private Map<Integer, DataPartition<T>> partitions = new HashMap<Integer, DataPartition<T>>();
    private transient Config config;
    private String id;

    public DataObjectImpl(Config conf) {
        this.config = conf;
    }

    public DataObjectImpl(String name, Config conf) {
        this.id = name;
        this.config = conf;
    }

    public void addPartition(DataPartition<T> partition) {
        this.partitions.put(partition.getPartitionId(), partition);
    }

    public DataPartition<T>[] getPartitions() {
        DataPartition[] parts = new DataPartition[this.partitions.size()];
        return this.partitions.values().toArray(parts);
    }

    public DataPartition<T> getPartition(int partitionId) {
        return this.partitions.get(partitionId);
    }

    public int getPartitionCount() {
        return this.partitions.size();
    }

    public String getID() {
        if (this.id != null && !this.id.isEmpty()) {
            return this.id;
        }
        throw new RuntimeException("Unnamed data object");
    }
}

