/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.dataset;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.data.api.InputPartitioner;
import edu.iu.dsc.tws.data.fs.io.InputSplit;
import edu.iu.dsc.tws.data.fs.io.InputSplitAssigner;
import edu.iu.dsc.tws.dataset.DataObjectImpl;
import java.io.IOException;
import java.util.logging.Logger;

public class DataSource<T, O extends InputSplit<T>>
extends DataObjectImpl<T> {
    private static final Logger LOG = Logger.getLogger(DataSource.class.getName());
    private InputPartitioner<T, O> input;
    private O[] splits;
    private Config config;

    public DataSource(Config cfg, InputPartitioner<T, O> input, int numSplits) {
        super(cfg);
        this.config = cfg;
        this.input = input;
        this.input.configure(cfg);
        try {
            this.splits = this.input.createInputSplits(numSplits);
        }
        catch (Exception e) {
            throw new Twister2RuntimeException("Failed to create the input splits because, it", (Throwable)e);
        }
    }

    public InputSplit<T> getNextSplit(int id) {
        InputSplitAssigner assigner = this.input.getInputSplitAssigner((InputSplit[])this.splits);
        InputSplit split = assigner.getNextInputSplit("localhost", id);
        if (split != null) {
            try {
                split.open(this.config);
            }
            catch (IOException e) {
                throw new Twister2RuntimeException("Failed to open the input split because, it", (Throwable)e);
            }
            return split;
        }
        return null;
    }
}

