/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.dataset.partition;

import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import edu.iu.dsc.tws.dataset.partition.BufferedCollectionPartition;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class HDFSBackedCollectionPartition<T>
extends BufferedCollectionPartition<T> {
    private static final String CONFIG_HDFS_ROOT = "twister2.data.hdfs.root";
    private static final String HDFS_PROTO = "hdfs://";

    public HDFSBackedCollectionPartition(int maxFramesInMemory, MessageType dataType, int bufferedBytes, Config config, String reference) {
        super(maxFramesInMemory, dataType, bufferedBytes, config, reference);
    }

    public HDFSBackedCollectionPartition(int maxFramesInMemory, Config config) {
        super(maxFramesInMemory, config);
    }

    public HDFSBackedCollectionPartition(int maxFramesInMemory, MessageType dataType, Config config) {
        super((long)maxFramesInMemory, dataType, config);
    }

    public HDFSBackedCollectionPartition(MessageType dataType, int bufferedBytes, Config config) {
        super(dataType, bufferedBytes, config);
    }

    public HDFSBackedCollectionPartition(MessageType dataType, int bufferedBytes, Config config, String reference) {
        super(dataType, bufferedBytes, config, reference);
    }

    protected String getRootPathStr(Config config) {
        return HDFS_PROTO + String.join((CharSequence)File.separator, config.getStringValue(CONFIG_HDFS_ROOT), String.join((CharSequence)File.separator, this.getReference()));
    }

    @Override
    protected FileSystem getFileSystem(Config config) {
        try {
            return FileSystemUtils.get(URI.create(this.getRootPathStr(config)), config);
        }
        catch (IOException e) {
            throw new Twister2RuntimeException("Error in connecting to file system", (Throwable)e);
        }
    }

    @Override
    protected Path getRootPath(Config config) {
        return new Path(this.getRootPathStr(config));
    }
}

