//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
package edu.iu.dsc.tws.data.utils;

/**
 * Util class for network related functions
 */
public final class NetUtils {

  private NetUtils() {

  }

  /**
   * Turn a fully qualified domain name (fqdn) into a hostname. If the fqdn has multiple subparts
   * (separated by a period '.'), it will take the first part. Otherwise it takes the entire fqdn.
   *
   * @param fqdn The fully qualified domain name.
   * @return The hostname.
   */
  public static String getHostnameFromFQDN(String fqdn) {
    if (fqdn == null) {
      throw new IllegalArgumentException("fqdn is null");
    }
    int dotPos = fqdn.indexOf('.');
    if (dotPos == -1) {
      return fqdn;
    } else {
      return fqdn.substring(0, dotPos);
    }
  }
}
