/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.dashclient.messages;

import edu.iu.dsc.tws.master.dashclient.models.Node;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.Map;

public class RegisterWorker {
    private String jobID;
    private int workerID;
    private String workerIP;
    private int workerPort;
    private int computeResourceIndex;
    private String state;
    private Node node;
    private Map<String, Integer> additionalPorts;

    public RegisterWorker() {
    }

    public RegisterWorker(String jobID, JobMasterAPI.WorkerInfo workerInfo, JobMasterAPI.WorkerState initialState) {
        this.jobID = jobID;
        this.workerID = workerInfo.getWorkerID();
        this.workerIP = workerInfo.getWorkerIP();
        this.workerPort = workerInfo.getPort();
        this.computeResourceIndex = workerInfo.getComputeResource().getIndex();
        this.node = new Node(workerInfo.getNodeInfo());
        this.state = initialState.name();
        this.additionalPorts = workerInfo.getAdditionalPortMap();
    }

    public int getComputeResourceIndex() {
        return this.computeResourceIndex;
    }

    public String getJobID() {
        return this.jobID;
    }

    public Node getNode() {
        return this.node;
    }

    public String getWorkerIP() {
        return this.workerIP;
    }

    public int getWorkerID() {
        return this.workerID;
    }

    public int getWorkerPort() {
        return this.workerPort;
    }

    public String getState() {
        return this.state;
    }

    public Map<String, Integer> getAdditionalPorts() {
        return this.additionalPorts;
    }

    public void setComputeResourceIndex(int computeResourceIndex) {
        this.computeResourceIndex = computeResourceIndex;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    public void setNode(Node nodeObject) {
        this.node = nodeObject;
    }

    public void setWorkerIP(String workerIP) {
        this.workerIP = workerIP;
    }

    public void setWorkerID(int workerID) {
        this.workerID = workerID;
    }

    public void setWorkerPort(int workerPort) {
        this.workerPort = workerPort;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAdditionalPorts(Map<String, Integer> additionalPorts) {
        this.additionalPorts = additionalPorts;
    }

    public String toString() {
        return "{\"workerID\": " + this.workerID + ", \"workerIP\": \"" + this.workerIP + "\", \"workerPort\": " + this.workerPort + ", \"jobID\": \"" + this.jobID + "\", \"computeResourceIndex\": " + this.computeResourceIndex + ", " + this.node + '}';
    }
}

