/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.server;

import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.net.request.MessageHandler;
import edu.iu.dsc.tws.api.net.request.RequestID;
import edu.iu.dsc.tws.common.net.tcp.request.RRServer;
import edu.iu.dsc.tws.master.server.WorkerMonitor;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BarrierHandler
implements MessageHandler {
    private static final Logger LOG = Logger.getLogger(BarrierHandler.class.getName());
    private WorkerMonitor workerMonitor;
    private int numberOfWorkersOnBarrier;
    private HashMap<Integer, RequestID> waitList;
    private RRServer rrServer;

    public BarrierHandler(WorkerMonitor workerMonitor, RRServer rrServer) {
        this.workerMonitor = workerMonitor;
        this.rrServer = rrServer;
        this.waitList = new HashMap();
    }

    public void onMessage(RequestID requestID, int workerId, Message message) {
        if (message instanceof JobMasterAPI.BarrierRequest) {
            JobMasterAPI.BarrierRequest barrierRequest = (JobMasterAPI.BarrierRequest)message;
            if (this.waitList.size() == 0) {
                this.numberOfWorkersOnBarrier = this.workerMonitor.getNumberOfWorkers();
                LOG.fine("BarrierRequest message received from the first worker:\n" + barrierRequest);
            } else if (this.waitList.size() == this.numberOfWorkersOnBarrier - 1) {
                LOG.fine("BarrierRequest message received from the last worker:\n" + barrierRequest);
            } else {
                LOG.fine("BarrierRequest message received:\n" + barrierRequest);
            }
            this.waitList.put(barrierRequest.getWorkerID(), requestID);
            if (this.waitList.size() == this.numberOfWorkersOnBarrier) {
                this.sendBarrierResponseToWaitList();
            }
        } else {
            LOG.log(Level.SEVERE, "Un-known message received: " + message);
        }
    }

    private void sendBarrierResponseToWaitList() {
        LOG.fine("All workers reached the barrier. BarrierResponse message will be sent to all workers.");
        for (Map.Entry<Integer, RequestID> entry : this.waitList.entrySet()) {
            JobMasterAPI.BarrierResponse response = JobMasterAPI.BarrierResponse.newBuilder().setWorkerID(entry.getKey().intValue()).build();
            this.rrServer.sendResponse(entry.getValue(), (Message)response);
            LOG.fine("BarrierResponse message sent:\n" + response);
        }
        this.waitList.clear();
        this.numberOfWorkersOnBarrier = 0;
    }
}

