/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.worker;

import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.checkpointing.CheckpointingClient;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.exceptions.net.BlockingSendException;
import edu.iu.dsc.tws.api.net.request.MessageHandler;
import edu.iu.dsc.tws.api.net.request.RequestID;
import edu.iu.dsc.tws.api.resource.ControllerContext;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.common.net.tcp.request.RRClient;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMWorkerController
implements IWorkerController,
MessageHandler {
    private static final Logger LOG = Logger.getLogger(JMWorkerController.class.getName());
    private JobMasterAPI.WorkerInfo thisWorker;
    private ArrayList<JobMasterAPI.WorkerInfo> workerList;
    private int numberOfWorkers;
    private RRClient rrClient;
    private CheckpointingClient checkpointingClient;
    private Config config;

    public JMWorkerController(Config config, JobMasterAPI.WorkerInfo thisWorker, RRClient rrClient, CheckpointingClient checkpointingClient) {
        this(config, thisWorker, rrClient, JobMasterContext.workerInstances((Config)config), checkpointingClient);
    }

    public JMWorkerController(Config config, JobMasterAPI.WorkerInfo thisWorker, RRClient rrClient, int numberOfWorkers, CheckpointingClient checkpointingClient) {
        this.config = config;
        this.numberOfWorkers = numberOfWorkers;
        this.thisWorker = thisWorker;
        this.rrClient = rrClient;
        this.checkpointingClient = checkpointingClient;
        this.workerList = new ArrayList();
        this.workerList.add(thisWorker);
    }

    public JobMasterAPI.WorkerInfo getWorkerInfo() {
        return this.thisWorker;
    }

    public void scaled(int change, int numOfWorkers) {
        this.numberOfWorkers = numOfWorkers;
        if (change < 0) {
            for (int i = 1; i <= 0 - change; ++i) {
                int idToDelete = numOfWorkers - i;
                JobMasterAPI.WorkerInfo workerInfoToDelete = this.getWorkerInfoForID(idToDelete);
                this.workerList.remove(workerInfoToDelete);
            }
        }
    }

    public JobMasterAPI.WorkerInfo getWorkerInfoForID(int id) {
        for (JobMasterAPI.WorkerInfo info : this.workerList) {
            if (info.getWorkerID() != id) continue;
            return info;
        }
        return null;
    }

    public int getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    public List<JobMasterAPI.WorkerInfo> getJoinedWorkers() {
        if (this.workerList.size() == this.numberOfWorkers) {
            return this.workerList;
        }
        this.sendWorkerListRequest(JobMasterAPI.ListWorkersRequest.RequestType.IMMEDIATE_RESPONSE, JobMasterContext.responseWaitDuration(this.config));
        return this.workerList;
    }

    public List<JobMasterAPI.WorkerInfo> getAllWorkers() throws TimeoutException {
        if (this.workerList.size() == this.numberOfWorkers) {
            return this.workerList;
        }
        long timeLimit = ControllerContext.maxWaitTimeForAllToJoin((Config)this.config);
        boolean sentAndReceived = this.sendWorkerListRequest(JobMasterAPI.ListWorkersRequest.RequestType.RESPONSE_AFTER_ALL_JOINED, timeLimit);
        if (!sentAndReceived) {
            throw new TimeoutException("All workers have not joined the job on the specified time limit: " + timeLimit + "ms.");
        }
        return this.workerList;
    }

    private boolean sendWorkerListRequest(JobMasterAPI.ListWorkersRequest.RequestType requestType, long timeLimit) {
        JobMasterAPI.ListWorkersRequest listRequest = JobMasterAPI.ListWorkersRequest.newBuilder().setWorkerID(this.thisWorker.getWorkerID()).setRequestType(requestType).build();
        LOG.fine("Sending ListWorkers message to the master: \n" + listRequest);
        try {
            this.rrClient.sendRequestWaitResponse((Message)listRequest, timeLimit);
            return true;
        }
        catch (BlockingSendException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public void onMessage(RequestID id, int workerId, Message message) {
        if (message instanceof JobMasterAPI.ListWorkersResponse) {
            LOG.fine("ListWorkersResponse message received from the master: \n" + message);
            JobMasterAPI.ListWorkersResponse listResponse = (JobMasterAPI.ListWorkersResponse)message;
            List receivedWorkerInfos = listResponse.getWorkerList();
            this.workerList.clear();
            this.workerList.add(this.thisWorker);
            for (JobMasterAPI.WorkerInfo receivedWorkerInfo : receivedWorkerInfos) {
                if (receivedWorkerInfo.getWorkerID() == this.thisWorker.getWorkerID()) continue;
                this.workerList.add(receivedWorkerInfo);
            }
        } else if (message instanceof JobMasterAPI.BarrierResponse) {
            LOG.fine("Received a BarrierResponse message from the master. \n" + message);
        } else {
            LOG.warning("Received message unrecognized. \n" + message);
        }
    }

    public void waitOnBarrier() throws TimeoutException {
        JobMasterAPI.BarrierRequest barrierRequest = JobMasterAPI.BarrierRequest.newBuilder().setWorkerID(this.thisWorker.getWorkerID()).build();
        LOG.fine("Sending BarrierRequest message: \n" + barrierRequest.toString());
        try {
            this.rrClient.sendRequestWaitResponse((Message)barrierRequest, ControllerContext.maxWaitTimeOnBarrier((Config)this.config));
        }
        catch (BlockingSendException e) {
            throw new TimeoutException("All workers have not arrived at the barrier on the time limit: " + ControllerContext.maxWaitTimeOnBarrier((Config)this.config) + "ms.", (Throwable)e);
        }
    }

    public static InetAddress convertStringToIP(String ipStr) {
        try {
            return InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Can not convert the IP string to InetAddress: " + ipStr, e);
            throw new RuntimeException(e);
        }
    }

    public CheckpointingClient getCheckpointingClient() {
        return this.checkpointingClient;
    }
}

