/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.barrier;

import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.net.request.MessageHandler;
import edu.iu.dsc.tws.api.net.request.RequestID;
import edu.iu.dsc.tws.common.net.tcp.request.RRServer;
import edu.iu.dsc.tws.master.barrier.BarrierMonitor;
import edu.iu.dsc.tws.master.barrier.BarrierResponder;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class JMBarrierHandler
implements MessageHandler,
BarrierResponder {
    private static final Logger LOG = Logger.getLogger(JMBarrierHandler.class.getName());
    private RRServer rrServer;
    private BarrierMonitor barrierMonitor;
    private TreeMap<Integer, RequestID> defaultWaitList;
    private TreeMap<Integer, RequestID> initWaitList;

    public JMBarrierHandler(RRServer rrServer, BarrierMonitor barrierMonitor) {
        this.rrServer = rrServer;
        this.barrierMonitor = barrierMonitor;
        this.defaultWaitList = new TreeMap();
        this.initWaitList = new TreeMap();
        JobMasterAPI.BarrierRequest.Builder barrierRequestBuilder = JobMasterAPI.BarrierRequest.newBuilder();
        JobMasterAPI.BarrierResponse.Builder barrierResponseBuilder = JobMasterAPI.BarrierResponse.newBuilder();
        rrServer.registerRequestHandler((Message.Builder)barrierRequestBuilder, (MessageHandler)this);
        rrServer.registerRequestHandler((Message.Builder)barrierResponseBuilder, (MessageHandler)this);
    }

    public void onMessage(RequestID requestID, int workerId, Message message) {
        if (!(message instanceof JobMasterAPI.BarrierRequest)) {
            LOG.severe("Un-known message type received: " + message + " Ignoring this message.");
            return;
        }
        JobMasterAPI.BarrierRequest barrierRequest = (JobMasterAPI.BarrierRequest)message;
        if (barrierRequest.getBarrierType() == JobMasterAPI.BarrierType.DEFAULT) {
            this.defaultWaitList.put(barrierRequest.getWorkerID(), requestID);
            this.barrierMonitor.arrivedAtDefault(barrierRequest.getWorkerID(), barrierRequest.getTimeout());
        } else if (barrierRequest.getBarrierType() == JobMasterAPI.BarrierType.INIT) {
            this.initWaitList.put(barrierRequest.getWorkerID(), requestID);
            this.barrierMonitor.arrivedAtInit(barrierRequest.getWorkerID(), barrierRequest.getTimeout());
        } else {
            LOG.warning("Received barrier request with unrecognized type: " + barrierRequest.getBarrierType() + " Ignoring this event.");
        }
    }

    @Override
    public void allArrived(JobMasterAPI.BarrierType barrierType) {
        if (barrierType == JobMasterAPI.BarrierType.DEFAULT) {
            this.sendBarrierResponses(this.defaultWaitList, barrierType, JobMasterAPI.BarrierResult.SUCCESS);
            this.defaultWaitList.clear();
        } else if (barrierType == JobMasterAPI.BarrierType.INIT) {
            this.sendBarrierResponses(this.initWaitList, barrierType, JobMasterAPI.BarrierResult.SUCCESS);
            this.initWaitList.clear();
        }
    }

    @Override
    public void barrierFailed(JobMasterAPI.BarrierType barrierType, JobMasterAPI.BarrierResult result) {
        if (barrierType == JobMasterAPI.BarrierType.DEFAULT) {
            this.sendBarrierResponses(this.defaultWaitList, barrierType, result);
            this.defaultWaitList.clear();
        } else if (barrierType == JobMasterAPI.BarrierType.INIT) {
            this.sendBarrierResponses(this.initWaitList, barrierType, result);
            this.initWaitList.clear();
        }
    }

    private void sendBarrierResponses(Map<Integer, RequestID> waitList, JobMasterAPI.BarrierType barrierType, JobMasterAPI.BarrierResult result) {
        for (Map.Entry<Integer, RequestID> entry : waitList.entrySet()) {
            JobMasterAPI.BarrierResponse response = JobMasterAPI.BarrierResponse.newBuilder().setWorkerID(entry.getKey().intValue()).setBarrierType(barrierType).setResult(result).build();
            this.rrServer.sendResponse(entry.getValue(), (Message)response);
            LOG.fine("BarrierResponse message sent:\n" + response);
        }
    }

    private void sendFailResponse(RequestID requestID, int workerID, JobMasterAPI.BarrierType barrierType, JobMasterAPI.BarrierResult result) {
        JobMasterAPI.BarrierResponse response = JobMasterAPI.BarrierResponse.newBuilder().setWorkerID(workerID).setBarrierType(barrierType).setResult(result).build();
        this.rrServer.sendResponse(requestID, (Message)response);
        LOG.fine("Sending failed BarrierResponse message:\n" + response);
    }
}

