/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.driver;

import edu.iu.dsc.tws.api.driver.IScaler;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.driver.NullScaler;
import edu.iu.dsc.tws.master.server.WorkerMonitor;
import edu.iu.dsc.tws.master.server.ZKJobUpdater;
import java.util.logging.Logger;

public class Scaler
implements IScaler {
    private static final Logger LOG = Logger.getLogger(Scaler.class.getName());
    private IScalerPerCluster clusterScaler;
    private WorkerMonitor workerMonitor;
    private ZKJobUpdater zkJobUpdater;

    public Scaler(IScalerPerCluster clusterScaler, WorkerMonitor workerMonitor, ZKJobUpdater zkJobUpdater) {
        this.workerMonitor = workerMonitor;
        this.clusterScaler = clusterScaler;
        this.zkJobUpdater = zkJobUpdater;
        if (this.clusterScaler == null) {
            this.clusterScaler = new NullScaler();
        }
    }

    public boolean isScalable() {
        return this.clusterScaler.isScalable();
    }

    public boolean scaleUpWorkers(int instancesToAdd) {
        LOG.info("Current numberOfWorkers: " + this.workerMonitor.getNumberOfWorkers() + ", new workers to be added: " + instancesToAdd);
        if (!this.isScalable()) {
            LOG.severe("Job is not scalable. Either ComputeResource is not scalable or this is an OpenMPI job.");
            return false;
        }
        if (instancesToAdd <= 0) {
            LOG.severe("instancesToAdd has to be a positive integer");
            return false;
        }
        boolean scaledUp = this.clusterScaler.scaleUpWorkers(instancesToAdd);
        if (!scaledUp) {
            return false;
        }
        this.workerMonitor.workersScaledUp(instancesToAdd);
        return this.zkJobUpdater.updateWorkers(instancesToAdd);
    }

    public boolean scaleDownWorkers(int instancesToRemove) {
        if (!this.isScalable()) {
            LOG.severe("Job is not scalable. Either ComputeResource is not scalable or this is an OpenMPI job.");
            return false;
        }
        if (instancesToRemove <= 0) {
            LOG.severe("instancesToRemove has to be a positive integer");
            return false;
        }
        boolean scaledDown = this.clusterScaler.scaleDownWorkers(instancesToRemove, this.workerMonitor.getNumberOfWorkers());
        if (!scaledDown) {
            return false;
        }
        int maxID = this.workerMonitor.getNumberOfWorkers();
        this.workerMonitor.workersScaledDown(instancesToRemove);
        int minID = maxID - instancesToRemove;
        int workerChange = 0 - instancesToRemove;
        boolean updatedJobInZK = this.zkJobUpdater.updateWorkers(workerChange);
        boolean checkZNodesDeleted = this.zkJobUpdater.removeInitialStateZNodes(minID, maxID);
        return updatedJobInZK && checkZNodesDeleted;
    }
}

