/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.server;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.common.zk.JobZNodeManager;
import edu.iu.dsc.tws.common.zk.ZKBarrierManager;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKPersStateManager;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;

public class ZKJobUpdater {
    private static final Logger LOG = Logger.getLogger(ZKJobUpdater.class.getName());
    private Config config;
    private String jobID;

    public ZKJobUpdater(Config config, String jobID) {
        this.config = config;
        this.jobID = jobID;
    }

    public boolean updateState(JobAPI.JobState newState) {
        if (!ZKContext.isZooKeeperServerUsed((Config)this.config)) {
            return true;
        }
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)this.config));
        String rootPath = ZKContext.rootNode((Config)this.config);
        try {
            JobZNodeManager.updateJobState((CuratorFramework)client, (String)rootPath, (String)this.jobID, (JobAPI.JobState)newState);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not update job znode", e);
            return false;
        }
    }

    public boolean updateWorkers(int workerChange) {
        if (!ZKContext.isZooKeeperServerUsed((Config)this.config)) {
            return true;
        }
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)this.config));
        String rootPath = ZKContext.rootNode((Config)this.config);
        try {
            JobZNodeManager.updateJobWorkers((CuratorFramework)client, (String)rootPath, (String)this.jobID, (int)workerChange);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not update job znode", e);
            return false;
        }
    }

    public boolean removeInitialStateZNodes(int minWorkerID, int maxWorkerID) {
        if (!ZKContext.isZooKeeperServerUsed((Config)this.config)) {
            return true;
        }
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)this.config));
        String rootPath = ZKContext.rootNode((Config)this.config);
        try {
            ZKPersStateManager.removeScaledDownZNodes((CuratorFramework)client, (String)rootPath, (String)this.jobID, (int)minWorkerID, (int)maxWorkerID);
            ZKBarrierManager.removeScaledDownZNodes((CuratorFramework)client, (String)rootPath, (String)this.jobID, (int)minWorkerID, (int)maxWorkerID);
            return true;
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }
}

