/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.barrier;

import edu.iu.dsc.tws.api.faulttolerance.JobFaultListener;
import edu.iu.dsc.tws.api.resource.InitBarrierListener;
import edu.iu.dsc.tws.master.barrier.BarrierResponder;
import edu.iu.dsc.tws.master.server.WorkerMonitor;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class BarrierMonitor
implements JobFaultListener {
    private static final Logger LOG = Logger.getLogger(BarrierMonitor.class.getName());
    private WorkerMonitor workerMonitor;
    private LongObject expectedWorkersOnDefault = new LongObject(0L);
    private LongObject expectedWorkersOnInit = new LongObject(0L);
    private LongObject defaultStartTime = new LongObject(0L);
    private LongObject initStartTime = new LongObject(0L);
    private LongObject defaultTimeout = new LongObject(0L);
    private LongObject initTimeout = new LongObject(0L);
    private TreeSet<Integer> defaultWaitList;
    private TreeSet<Integer> initWaitList;
    private InitBarrierListener initBarrierListener;
    private BarrierResponder barrierResponder;
    private boolean faultOccurred = false;
    private boolean firstInitProceeded = false;

    public BarrierMonitor(WorkerMonitor workerMonitor, InitBarrierListener barrierListener) {
        this.workerMonitor = workerMonitor;
        this.initBarrierListener = barrierListener;
        this.defaultWaitList = new TreeSet();
        this.initWaitList = new TreeSet();
    }

    public void setBarrierResponder(BarrierResponder barrierResponder) {
        this.barrierResponder = barrierResponder;
    }

    public void initDefaultAfterRestart(Set<Integer> initialWorkers, long timeout, int expectedWorkers) {
        this.defaultWaitList.addAll(initialWorkers);
        this.defaultTimeout.number = timeout;
        this.expectedWorkersOnDefault.number = expectedWorkers;
        this.defaultStartTime.number = System.currentTimeMillis();
    }

    public void initInitAfterRestart(Set<Integer> initialWorkers, long timeout, int expectedWorkers) {
        this.initWaitList.addAll(initialWorkers);
        this.initTimeout.number = timeout;
        this.expectedWorkersOnInit.number = expectedWorkers;
        this.initStartTime.number = System.currentTimeMillis();
    }

    public boolean isFirstInitProceeded() {
        return this.firstInitProceeded;
    }

    public void faultOccurred() {
        this.faultOccurred = true;
    }

    public void faultRestored() {
    }

    public void arrivedAtDefault(int workerID, long timeout) {
        this.arrived(workerID, timeout, this.defaultWaitList, JobMasterAPI.BarrierType.DEFAULT, this.expectedWorkersOnDefault, this.defaultStartTime, this.defaultTimeout);
    }

    public void arrivedAtInit(int workerID, long timeout) {
        this.arrived(workerID, timeout, this.initWaitList, JobMasterAPI.BarrierType.INIT, this.expectedWorkersOnInit, this.initStartTime, this.initTimeout);
    }

    public void checkBarrierFailure() {
        long delay;
        if (this.initStartTime.number > 0L && (delay = System.currentTimeMillis() - this.initStartTime.number) > this.initTimeout.number) {
            this.barrierResponder.barrierFailed(JobMasterAPI.BarrierType.INIT, JobMasterAPI.BarrierResult.TIMED_OUT);
            this.barrierCompleted(this.initWaitList, this.expectedWorkersOnInit, this.initStartTime, this.initTimeout);
        }
        if (this.defaultStartTime.number > 0L && (delay = System.currentTimeMillis() - this.defaultStartTime.number) > this.defaultTimeout.number) {
            this.barrierResponder.barrierFailed(JobMasterAPI.BarrierType.DEFAULT, JobMasterAPI.BarrierResult.TIMED_OUT);
            this.barrierCompleted(this.defaultWaitList, this.expectedWorkersOnDefault, this.defaultStartTime, this.defaultTimeout);
        }
        if (this.faultOccurred) {
            this.faultOccurred = false;
            if (!this.defaultWaitList.isEmpty()) {
                LOG.info("number of workers at DEFAULT barrier when the fault occurred: " + this.defaultWaitList.size());
                this.barrierResponder.barrierFailed(JobMasterAPI.BarrierType.DEFAULT, JobMasterAPI.BarrierResult.JOB_FAULTY);
                this.barrierCompleted(this.defaultWaitList, this.expectedWorkersOnDefault, this.defaultStartTime, this.defaultTimeout);
            }
        }
    }

    public void removedFromDefault(int workerID) {
        if ((long)workerID >= this.expectedWorkersOnDefault.number) {
            return;
        }
        if (workerID < 0) {
            return;
        }
        this.defaultWaitList.remove(workerID);
        if (this.defaultWaitList.isEmpty()) {
            this.expectedWorkersOnDefault.number = 0L;
            this.defaultStartTime.number = 0L;
            this.defaultTimeout.number = 0L;
        }
    }

    public void removedFromInit(int workerID) {
        if ((long)workerID >= this.expectedWorkersOnDefault.number) {
            return;
        }
        if (workerID < 0) {
            return;
        }
        this.initWaitList.remove(workerID);
        if (this.initWaitList.isEmpty()) {
            this.expectedWorkersOnInit.number = 0L;
            this.initStartTime.number = 0L;
            this.initTimeout.number = 0L;
        }
    }

    private void barrierCompleted(TreeSet<Integer> waitList, LongObject expectedWorkers, LongObject startTime, LongObject barrierTimeout) {
        waitList.clear();
        expectedWorkers.number = 0L;
        startTime.number = 0L;
        barrierTimeout.number = 0L;
    }

    private void arrived(int workerID, long timeout, TreeSet<Integer> waitList, JobMasterAPI.BarrierType barrierType, LongObject expectedWorkers, LongObject startTime, LongObject barrierTimeout) {
        if (workerID < 0) {
            LOG.severe("A worker arrived at the " + barrierType + " barrier with a workerID that is less than zero:" + workerID + ". Ignoring this barrier message.");
            return;
        }
        if (expectedWorkers.number > 0L && (long)workerID >= expectedWorkers.number || expectedWorkers.number == 0L && workerID >= this.workerMonitor.getNumberOfWorkers()) {
            LOG.severe("A worker arrived at the " + barrierType + " barrier with a workerID that is larger than max workerID in the job: " + workerID + ". Ignoring this barrier event.");
            return;
        }
        if (waitList.isEmpty()) {
            LOG.fine("First worker[" + workerID + "] arrived at the " + barrierType + " barrier");
            expectedWorkers.number = this.workerMonitor.getNumberOfWorkers();
            startTime.number = System.currentTimeMillis();
            barrierTimeout.number = timeout;
        } else {
            LOG.fine("Worker[" + workerID + "] arrived at the " + barrierType + " barrier");
        }
        waitList.add(workerID);
        if ((long)waitList.size() == expectedWorkers.number) {
            if (barrierType == JobMasterAPI.BarrierType.INIT && this.initBarrierListener != null) {
                this.initBarrierListener.allArrived();
            }
            LOG.info("All workers reached the " + barrierType + " barrier: " + expectedWorkers);
            this.barrierResponder.allArrived(barrierType);
            this.barrierCompleted(waitList, expectedWorkers, startTime, barrierTimeout);
            if (barrierType == JobMasterAPI.BarrierType.INIT) {
                this.firstInitProceeded = true;
            }
        }
    }

    private class LongObject {
        long number;

        LongObject(long n) {
            this.number = n;
        }

        public String toString() {
            return this.number + "";
        }
    }
}

