/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.worker;

import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.net.BlockingSendException;
import edu.iu.dsc.tws.api.net.request.MessageHandler;
import edu.iu.dsc.tws.api.net.request.RequestID;
import edu.iu.dsc.tws.api.resource.IWorkerFailureListener;
import edu.iu.dsc.tws.api.resource.IWorkerStatusUpdater;
import edu.iu.dsc.tws.common.net.tcp.request.RRClient;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.worker.JMWorkerController;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMWorkerStatusUpdater
implements IWorkerStatusUpdater,
MessageHandler {
    private static final Logger LOG = Logger.getLogger(JMWorkerController.class.getName());
    private RRClient rrClient;
    private int workerID;
    private Config config;
    private IWorkerFailureListener workerFailureListener;
    private LinkedList<Message> messageBuffer = new LinkedList();

    public JMWorkerStatusUpdater(RRClient rrClient, int workerID, Config config) {
        this.rrClient = rrClient;
        this.workerID = workerID;
        this.config = config;
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.WorkerFailed.newBuilder(), (MessageHandler)this);
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.WorkerRestarted.newBuilder(), (MessageHandler)this);
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.WorkerStateChange.newBuilder(), (MessageHandler)this);
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.WorkerStateChangeResponse.newBuilder(), (MessageHandler)this);
    }

    public boolean updateWorkerStatus(JobMasterAPI.WorkerState newState) {
        if (newState == JobMasterAPI.WorkerState.COMPLETED || newState == JobMasterAPI.WorkerState.KILLED || newState == JobMasterAPI.WorkerState.FAILED || newState == JobMasterAPI.WorkerState.FULLY_FAILED) {
            JobMasterAPI.WorkerStateChange workerStateChange = JobMasterAPI.WorkerStateChange.newBuilder().setWorkerID(this.workerID).setState(newState).build();
            LOG.fine("Sending the message: \n" + workerStateChange);
            try {
                this.rrClient.sendRequestWaitResponse((Message)workerStateChange, JobMasterContext.responseWaitDuration(this.config));
            }
            catch (BlockingSendException e) {
                LOG.log(Level.SEVERE, String.format("%d Worker completed message failed", this.workerID), e);
                return false;
            }
            return true;
        }
        LOG.severe("Unsupported state: " + newState);
        return false;
    }

    public boolean addWorkerFailureListener(IWorkerFailureListener workerFailureListener1) {
        if (this.workerFailureListener != null) {
            return false;
        }
        this.workerFailureListener = workerFailureListener1;
        this.deliverBufferedMessages();
        return true;
    }

    public JobMasterAPI.WorkerState getWorkerStatusForID(int id) {
        return null;
    }

    public void onMessage(RequestID id, int workerId, Message message) {
        if (message instanceof JobMasterAPI.WorkerStateChangeResponse) {
            LOG.fine("Received a WorkerStateChange response from the master. \n" + message);
        } else if (message instanceof JobMasterAPI.WorkerFailed) {
            if (this.workerFailureListener == null) {
                this.messageBuffer.add(message);
            } else {
                JobMasterAPI.WorkerFailed workerFailed = (JobMasterAPI.WorkerFailed)message;
                this.workerFailureListener.failed(workerFailed.getWorkerID());
            }
        } else if (message instanceof JobMasterAPI.WorkerRestarted) {
            if (this.workerFailureListener == null) {
                this.messageBuffer.add(message);
            } else {
                JobMasterAPI.WorkerRestarted workerRestarted = (JobMasterAPI.WorkerRestarted)message;
                this.workerFailureListener.restarted(workerRestarted.getWorkerInfo());
            }
        }
    }

    private void deliverBufferedMessages() {
        while (!this.messageBuffer.isEmpty()) {
            Message message = this.messageBuffer.poll();
            if (message instanceof JobMasterAPI.WorkerFailed) {
                JobMasterAPI.WorkerFailed workerFailed = (JobMasterAPI.WorkerFailed)message;
                this.workerFailureListener.failed(workerFailed.getWorkerID());
                continue;
            }
            if (!(message instanceof JobMasterAPI.WorkerRestarted)) continue;
            JobMasterAPI.WorkerRestarted workerRestarted = (JobMasterAPI.WorkerRestarted)message;
            this.workerFailureListener.restarted(workerRestarted.getWorkerInfo());
        }
    }
}

