/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.core;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.faulttolerance.FaultToleranceContext;
import edu.iu.dsc.tws.api.resource.IAllJoinedListener;
import edu.iu.dsc.tws.api.resource.IJobMasterFailureListener;
import edu.iu.dsc.tws.api.resource.IReceiverFromDriver;
import edu.iu.dsc.tws.api.resource.IScalerListener;
import edu.iu.dsc.tws.api.resource.ISenderToDriver;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.IWorkerFailureListener;
import edu.iu.dsc.tws.api.resource.IWorkerStatusUpdater;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import edu.iu.dsc.tws.common.zk.ZKWorkerController;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.worker.JMSenderToDriver;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.master.worker.JMWorkerStatusUpdater;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WorkerRuntime {
    private static final Logger LOG = Logger.getLogger(WorkerRuntime.class.getName());
    private static boolean initialized = false;
    private static Config config;
    private static JobAPI.Job job;
    private static JobMasterAPI.WorkerInfo workerInfo;
    private static ZKWorkerController zkWorkerController;
    private static JMWorkerAgent jmWorkerAgent;
    private static IWorkerController workerController;
    private static IWorkerStatusUpdater workerStatusUpdater;
    private static ISenderToDriver senderToDriver;
    private static IWorkerFailureListener failureListener;

    private WorkerRuntime() {
    }

    public static synchronized boolean init(Config cnfg, JobAPI.Job jb, JobMasterAPI.WorkerInfo wInfo, JobMasterAPI.WorkerState initialState) {
        if (initialized) {
            return false;
        }
        config = cnfg;
        job = jb;
        workerInfo = wInfo;
        String jobMasterIP = JobMasterContext.jobMasterIP((Config)config);
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            zkWorkerController = new ZKWorkerController(config, job.getJobId(), job.getNumberOfWorkers(), workerInfo);
            try {
                zkWorkerController.initialize(initialState);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception when initializing ZKWorkerController", e);
                throw new RuntimeException(e);
            }
            workerController = zkWorkerController;
            workerStatusUpdater = zkWorkerController;
        } else {
            jmWorkerAgent = JMWorkerAgent.createJMWorkerAgent((Config)config, (JobMasterAPI.WorkerInfo)workerInfo, (String)jobMasterIP, (int)JobMasterContext.jobMasterPort((Config)config), (int)job.getNumberOfWorkers(), (JobMasterAPI.WorkerState)initialState);
            jmWorkerAgent.startThreaded();
            workerController = jmWorkerAgent.getJMWorkerController();
            workerStatusUpdater = new JMWorkerStatusUpdater(jmWorkerAgent);
            senderToDriver = new JMSenderToDriver(jmWorkerAgent);
        }
        if (ZKContext.isZooKeeperServerUsed((Config)config) && !job.getDriverClassName().isEmpty()) {
            jmWorkerAgent = JMWorkerAgent.createJMWorkerAgent((Config)config, (JobMasterAPI.WorkerInfo)workerInfo, (String)jobMasterIP, (int)JobMasterContext.jobMasterPort((Config)config), (int)job.getNumberOfWorkers(), (JobMasterAPI.WorkerState)initialState);
            jmWorkerAgent.startThreaded();
            senderToDriver = new JMSenderToDriver(jmWorkerAgent);
            if (FaultToleranceContext.faultTolerant((Config)config)) {
                zkWorkerController.addJMFailureListener(new IJobMasterFailureListener(){

                    public void failed() {
                    }

                    public void restarted(String jobMasterAddress) {
                        LOG.info("JobMaster restarted. Worker will try to reconnect and re-register.");
                        jmWorkerAgent.reconnect(jobMasterAddress);
                    }
                });
            }
        }
        initialized = true;
        return true;
    }

    public static IWorkerController getWorkerController() {
        return workerController;
    }

    public static IWorkerStatusUpdater getWorkerStatusUpdater() {
        return workerStatusUpdater;
    }

    public static synchronized ISenderToDriver getSenderToDriver() {
        return senderToDriver;
    }

    public static boolean addWorkerFailureListener(IWorkerFailureListener workerFailureListener) {
        failureListener = workerFailureListener;
        if (zkWorkerController != null) {
            return zkWorkerController.addFailureListener(workerFailureListener);
        }
        return false;
    }

    public static IWorkerFailureListener getFailureListener() {
        return failureListener;
    }

    public static boolean addAllJoinedListener(IAllJoinedListener allJoinedListener) {
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            return zkWorkerController.addAllJoinedListener(allJoinedListener);
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addAllJoinedListener((IAllJoinedListener)allJoinedListener);
        }
        return false;
    }

    public static boolean addReceiverFromDriver(IReceiverFromDriver receiverFromDriver) {
        if (job.getDriverClassName().isEmpty()) {
            return false;
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addReceiverFromDriver((IReceiverFromDriver)receiverFromDriver);
        }
        return false;
    }

    public static boolean addScalerListener(IScalerListener scalerListener) {
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            return zkWorkerController.addScalerListener(scalerListener);
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addScalerListener((IScalerListener)scalerListener);
        }
        return false;
    }

    public static boolean addJMFailureListener(IJobMasterFailureListener jobMasterListener) {
        if (zkWorkerController != null) {
            return zkWorkerController.addJMFailureListener(jobMasterListener);
        }
        return false;
    }

    public static void close() {
        if (jmWorkerAgent != null) {
            jmWorkerAgent.close();
        }
        if (zkWorkerController != null) {
            zkWorkerController.close();
            ZKUtils.closeClient();
        }
    }
}

