/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.K8sEnvVariables;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.ResourceSchedulerUtils;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1Affinity;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1EmptyDirVolumeSource;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarSource;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import io.kubernetes.client.openapi.models.V1NFSVolumeSource;
import io.kubernetes.client.openapi.models.V1NodeAffinity;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorRequirement;
import io.kubernetes.client.openapi.models.V1NodeSelectorTerm;
import io.kubernetes.client.openapi.models.V1ObjectFieldSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimSpec;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimVolumeSource;
import io.kubernetes.client.openapi.models.V1PersistentVolumeSpec;
import io.kubernetes.client.openapi.models.V1PodAffinity;
import io.kubernetes.client.openapi.models.V1PodAffinityTerm;
import io.kubernetes.client.openapi.models.V1PodAntiAffinity;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1SecretVolumeSource;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public final class RequestObjectBuilder {
    private static final Logger LOG = Logger.getLogger(RequestObjectBuilder.class.getName());
    private static Config config;
    private static String jobID;
    private static long jobPackageFileSize;
    private static String jobMasterIP;
    public static String uploadMethod;

    private RequestObjectBuilder() {
    }

    public static void init(Config cnfg, String jID, long jpFileSize) {
        config = cnfg;
        jobID = jID;
        jobPackageFileSize = jpFileSize;
        if (JobMasterContext.jobMasterRunsInClient((Config)config) && (jobMasterIP = ResourceSchedulerUtils.getHostIP()) == null) {
            throw new RuntimeException("Can not get local host address. ");
        }
    }

    public static void setUploadMethod(String uploadType) {
        uploadMethod = uploadType;
    }

    public static String getJobMasterIP() {
        return jobMasterIP;
    }

    public static V1StatefulSet createStatefulSetForWorkers(JobAPI.ComputeResource computeResource, String encodedNodeInfoList) {
        if (config == null) {
            LOG.severe("RequestObjectBuilder.init method has not been called.");
            return null;
        }
        String statefulSetName = KubernetesUtils.createWorkersStatefulSetName(jobID, computeResource.getIndex());
        V1StatefulSet statefulSet = new V1StatefulSet();
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(statefulSetName);
        statefulSet.setMetadata(meta);
        V1StatefulSetSpec setSpec = new V1StatefulSetSpec();
        setSpec.serviceName(KubernetesUtils.createServiceName(jobID));
        setSpec.setPodManagementPolicy("Parallel");
        int numberOfPods = computeResource.getInstances();
        setSpec.setReplicas(Integer.valueOf(numberOfPods));
        V1LabelSelector selector = new V1LabelSelector();
        String serviceLabel = KubernetesUtils.createServiceLabel(jobID);
        selector.putMatchLabelsItem("app", serviceLabel);
        setSpec.setSelector(selector);
        V1PodTemplateSpec template = RequestObjectBuilder.constructPodTemplate(computeResource, serviceLabel, encodedNodeInfoList);
        setSpec.setTemplate(template);
        statefulSet.setSpec(setSpec);
        return statefulSet;
    }

    public static V1PodTemplateSpec constructPodTemplate(JobAPI.ComputeResource computeResource, String serviceLabel, String encodedNodeInfoList) {
        V1PodTemplateSpec template = new V1PodTemplateSpec();
        V1ObjectMeta templateMetaData = new V1ObjectMeta();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("app", serviceLabel);
        String jobPodsLabel = KubernetesUtils.createJobPodsLabel(jobID);
        labels.put("twister2-job-pods", jobPodsLabel);
        String workerRoleLabel = KubernetesUtils.createWorkerRoleLabel(jobID);
        labels.put("twister2-role", workerRoleLabel);
        templateMetaData.setLabels(labels);
        template.setMetadata(templateMetaData);
        V1PodSpec podSpec = new V1PodSpec();
        podSpec.setTerminationGracePeriodSeconds(Long.valueOf(0L));
        ArrayList<V1Volume> volumes = new ArrayList<V1Volume>();
        V1Volume memoryVolume = new V1Volume();
        memoryVolume.setName("twister2-memory-dir");
        V1EmptyDirVolumeSource volumeSource1 = new V1EmptyDirVolumeSource();
        volumeSource1.setMedium("Memory");
        memoryVolume.setEmptyDir(volumeSource1);
        volumes.add(memoryVolume);
        if (computeResource.getDiskGigaBytes() > 0.0) {
            double volumeSize = computeResource.getDiskGigaBytes() * (double)computeResource.getWorkersPerPod();
            V1Volume volatileVolume = RequestObjectBuilder.createVolatileVolume(volumeSize);
            volumes.add(volatileVolume);
        }
        if (SchedulerContext.persistentVolumeRequested((Config)config)) {
            String claimName = KubernetesUtils.createPersistentVolumeClaimName(jobID);
            V1Volume persistentVolume = RequestObjectBuilder.createPersistentVolume(claimName);
            volumes.add(persistentVolume);
        }
        if (SchedulerContext.useOpenMPI((Config)config)) {
            String secretName = KubernetesContext.secretName(config);
            V1Volume secretVolume = RequestObjectBuilder.createSecretVolume(secretName);
            volumes.add(secretVolume);
        }
        podSpec.setVolumes(volumes);
        int containersPerPod = computeResource.getWorkersPerPod();
        if (SchedulerContext.useOpenMPI((Config)config)) {
            containersPerPod = 1;
        }
        ArrayList<V1Container> containers = new ArrayList<V1Container>();
        for (int i = 0; i < containersPerPod; ++i) {
            containers.add(RequestObjectBuilder.constructContainer(computeResource, i, encodedNodeInfoList));
        }
        podSpec.setContainers(containers);
        if (computeResource.getIndex() == 0) {
            RequestObjectBuilder.constructAffinity(podSpec);
        }
        template.setSpec(podSpec);
        return template;
    }

    public static void constructAffinity(V1PodSpec podSpec) {
        String uniformMappingType;
        V1Affinity affinity = new V1Affinity();
        boolean affinitySet = false;
        if (KubernetesContext.workerToNodeMapping(config)) {
            RequestObjectBuilder.setNodeAffinity(affinity);
            affinitySet = true;
        }
        if ("all-same-node".equalsIgnoreCase(uniformMappingType = KubernetesContext.workerMappingUniform(config)) || "all-separate-nodes".equalsIgnoreCase(uniformMappingType)) {
            RequestObjectBuilder.setUniformMappingAffinity(affinity);
            affinitySet = true;
        }
        if (affinitySet) {
            podSpec.setAffinity(affinity);
        }
    }

    public static V1Volume createVolatileVolume(double volumeSize) {
        V1Volume volatileVolume = new V1Volume();
        volatileVolume.setName("twister2-volatile-dir");
        V1EmptyDirVolumeSource volumeSource2 = new V1EmptyDirVolumeSource();
        volumeSource2.setSizeLimit(new Quantity(String.format("%.2fGi", volumeSize)));
        volatileVolume.setEmptyDir(volumeSource2);
        return volatileVolume;
    }

    public static V1Volume createPersistentVolume(String claimName) {
        V1Volume persistentVolume = new V1Volume();
        persistentVolume.setName("persistent-volume");
        V1PersistentVolumeClaimVolumeSource perVolSource = new V1PersistentVolumeClaimVolumeSource();
        perVolSource.setClaimName(claimName);
        persistentVolume.setPersistentVolumeClaim(perVolSource);
        return persistentVolume;
    }

    public static V1Volume createSecretVolume(String secretName) {
        V1Volume secretVolume = new V1Volume();
        secretVolume.setName("kube-openmpi-ssh-key");
        V1SecretVolumeSource secretVolumeSource = new V1SecretVolumeSource();
        secretVolumeSource.setSecretName(secretName);
        secretVolumeSource.setDefaultMode(Integer.valueOf(256));
        secretVolume.setSecret(secretVolumeSource);
        return secretVolume;
    }

    public static V1Container constructContainer(JobAPI.ComputeResource computeResource, int containerIndex, String encodedNodeInfoList) {
        V1VolumeMount persVolumeMount;
        V1Container container = new V1Container();
        String containerName = KubernetesUtils.createContainerName(containerIndex);
        container.setName(containerName);
        String containerImage = KubernetesContext.twister2DockerImageForK8s(config);
        if (containerImage == null) {
            throw new RuntimeException("Container Image name is null. Config parameter: twister2.resource.kubernetes.docker.image can not be null");
        }
        container.setImage(containerImage);
        container.setImagePullPolicy(KubernetesContext.imagePullPolicy(config));
        String startScript = null;
        double cpuPerContainer = computeResource.getCpu();
        int ramPerContainer = computeResource.getRamMegaBytes() + 128;
        if (SchedulerContext.useOpenMPI((Config)config)) {
            startScript = "./init_openmpi.sh";
            cpuPerContainer *= (double)computeResource.getWorkersPerPod();
            ramPerContainer *= computeResource.getWorkersPerPod();
        } else {
            startScript = "./init.sh";
        }
        container.setCommand(Arrays.asList(startScript));
        V1ResourceRequirements resReq = new V1ResourceRequirements();
        if (KubernetesContext.bindWorkerToCPU(config)) {
            resReq.putLimitsItem("cpu", new Quantity(String.format("%.2f", cpuPerContainer)));
            resReq.putLimitsItem("memory", new Quantity(ramPerContainer + "Mi"));
        } else {
            resReq.putRequestsItem("cpu", new Quantity(String.format("%.2f", cpuPerContainer)));
            resReq.putRequestsItem("memory", new Quantity(ramPerContainer + "Mi"));
        }
        container.setResources(resReq);
        ArrayList<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>();
        V1VolumeMount memoryVolumeMount = new V1VolumeMount();
        memoryVolumeMount.setName("twister2-memory-dir");
        memoryVolumeMount.setMountPath("/twister2-memory-dir");
        volumeMounts.add(memoryVolumeMount);
        if (computeResource.getDiskGigaBytes() > 0.0) {
            V1VolumeMount volatileVolumeMount = new V1VolumeMount();
            volatileVolumeMount.setName("twister2-volatile-dir");
            volatileVolumeMount.setMountPath("/twister2-volatile");
            volumeMounts.add(volatileVolumeMount);
        }
        if (SchedulerContext.persistentVolumeRequested((Config)config)) {
            persVolumeMount = new V1VolumeMount();
            persVolumeMount.setName("persistent-volume");
            persVolumeMount.setMountPath("/persistent");
            volumeMounts.add(persVolumeMount);
        }
        if (SchedulerContext.useOpenMPI((Config)config)) {
            persVolumeMount = new V1VolumeMount();
            persVolumeMount.setName("kube-openmpi-ssh-key");
            persVolumeMount.setMountPath("/ssh-key/openmpi");
            volumeMounts.add(persVolumeMount);
        }
        container.setVolumeMounts(volumeMounts);
        int containerPort = KubernetesContext.workerBasePort(config) + containerIndex * (SchedulerContext.numberOfAdditionalPorts((Config)config) + 1);
        V1ContainerPort port = new V1ContainerPort();
        port.name("port11");
        port.containerPort(Integer.valueOf(containerPort));
        port.setProtocol(KubernetesContext.workerTransportProtocol(config));
        container.setPorts(Arrays.asList(port));
        container.setEnv(RequestObjectBuilder.constructEnvironmentVariables(containerName, containerPort, encodedNodeInfoList, computeResource.getRamMegaBytes()));
        return container;
    }

    public static List<V1EnvVar> constructEnvironmentVariables(String containerName, int workerPort, String encodedNodeInfoList, int jvmMem) {
        ArrayList<V1EnvVar> envVars = new ArrayList<V1EnvVar>();
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_ID) + "").value(jobID));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_PACKAGE_FILE_SIZE) + "").value(jobPackageFileSize + ""));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.CONTAINER_NAME) + "").value(containerName));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.USER_JOB_JAR_FILE) + "").value(SchedulerContext.userJobJarFile((Config)config)));
        V1ObjectFieldSelector fieldSelector = new V1ObjectFieldSelector();
        fieldSelector.setFieldPath("metadata.name");
        V1EnvVarSource varSource = new V1EnvVarSource();
        varSource.setFieldRef(fieldSelector);
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.POD_NAME) + "").valueFrom(varSource));
        fieldSelector = new V1ObjectFieldSelector();
        fieldSelector.setFieldPath("status.hostIP");
        varSource = new V1EnvVarSource();
        varSource.setFieldRef(fieldSelector);
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.HOST_IP) + "").valueFrom(varSource));
        fieldSelector = new V1ObjectFieldSelector();
        fieldSelector.setFieldPath("spec.nodeName");
        varSource = new V1EnvVarSource();
        varSource.setFieldRef(fieldSelector);
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.HOST_NAME) + "").valueFrom(varSource));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_MASTER_IP) + "").value(jobMasterIP));
        if (SchedulerContext.useOpenMPI((Config)config)) {
            envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.CLASS_TO_RUN) + "").value("edu.iu.dsc.tws.rsched.schedulers.k8s.mpi.MPIMasterStarter"));
        } else {
            envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.CLASS_TO_RUN) + "").value("edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sWorkerStarter"));
        }
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.POD_MEMORY_VOLUME) + "").value("/twister2-memory-dir"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_ARCHIVE_DIRECTORY) + "").value("twister2-job"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_PACKAGE_FILENAME) + "").value(JobUtils.createJobPackageFileName(jobID)));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.WORKER_PORT) + "").value(workerPort + ""));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.UPLOAD_METHOD) + "").value(uploadMethod));
        String uri = null;
        if (SchedulerContext.jobPackageUri((Config)config) != null) {
            uri = SchedulerContext.jobPackageUri((Config)config).toString();
        }
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_PACKAGE_URI) + "").value(uri));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.ENCODED_NODE_INFO_LIST) + "").value(encodedNodeInfoList));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.LOGGER_PROPERTIES_FILE) + "").value("common/logger.properties"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JVM_MEMORY_MB) + "").value(jvmMem + ""));
        return envVars;
    }

    public static void setNodeAffinity(V1Affinity affinity) {
        String key = KubernetesContext.workerMappingKey(config);
        String operator = KubernetesContext.workerMappingOperator(config);
        List<String> values = KubernetesContext.workerMappingValues(config);
        V1NodeSelectorRequirement nsRequirement = new V1NodeSelectorRequirement();
        nsRequirement.setKey(key);
        nsRequirement.setOperator(operator);
        nsRequirement.setValues(values);
        V1NodeSelectorTerm selectorTerm = new V1NodeSelectorTerm();
        selectorTerm.addMatchExpressionsItem(nsRequirement);
        V1NodeSelector nodeSelector = new V1NodeSelector();
        nodeSelector.addNodeSelectorTermsItem(selectorTerm);
        V1NodeAffinity nodeAffinity = new V1NodeAffinity();
        nodeAffinity.requiredDuringSchedulingIgnoredDuringExecution(nodeSelector);
        affinity.setNodeAffinity(nodeAffinity);
    }

    public static void setUniformMappingAffinity(V1Affinity affinity) {
        String mappingType = KubernetesContext.workerMappingUniform(config);
        String key = "app";
        String operator = "In";
        String serviceLabel = KubernetesUtils.createServiceLabel(jobID);
        List<String> values = Arrays.asList(serviceLabel);
        V1LabelSelectorRequirement labelRequirement = new V1LabelSelectorRequirement();
        labelRequirement.setKey(key);
        labelRequirement.setOperator(operator);
        labelRequirement.setValues(values);
        V1LabelSelector labelSelector = new V1LabelSelector();
        labelSelector.addMatchExpressionsItem(labelRequirement);
        V1PodAffinityTerm affinityTerm = new V1PodAffinityTerm();
        affinityTerm.setLabelSelector(labelSelector);
        affinityTerm.setTopologyKey("kubernetes.io/hostname");
        if ("all-same-node".equalsIgnoreCase(mappingType)) {
            V1PodAffinity podAffinity = new V1PodAffinity();
            podAffinity.requiredDuringSchedulingIgnoredDuringExecution(Arrays.asList(affinityTerm));
            affinity.setPodAffinity(podAffinity);
        } else if ("all-separate-nodes".equalsIgnoreCase(mappingType)) {
            V1PodAntiAffinity podAntiAffinity = new V1PodAntiAffinity();
            podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution(Arrays.asList(affinityTerm));
            affinity.setPodAntiAffinity(podAntiAffinity);
        }
    }

    public static V1Service createJobServiceObject() {
        String serviceName = KubernetesUtils.createServiceName(jobID);
        String serviceLabel = KubernetesUtils.createServiceLabel(jobID);
        return RequestObjectBuilder.createHeadlessServiceObject(serviceName, serviceLabel);
    }

    public static V1Service createHeadlessServiceObject(String serviceName, String serviceLabel) {
        V1Service service = new V1Service();
        service.setKind("Service");
        service.setApiVersion("v1");
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(serviceName);
        service.setMetadata(meta);
        V1ServiceSpec serviceSpec = new V1ServiceSpec();
        serviceSpec.setClusterIP("None");
        HashMap<String, String> selectors = new HashMap<String, String>();
        selectors.put("app", serviceLabel);
        serviceSpec.setSelector(selectors);
        service.setSpec(serviceSpec);
        return service;
    }

    public static V1Service createNodePortServiceObject() {
        String serviceName = KubernetesUtils.createServiceName(jobID);
        String serviceLabel = KubernetesUtils.createServiceLabel(jobID);
        int workerPort = KubernetesContext.workerBasePort(config);
        int nodePort = KubernetesContext.serviceNodePort(config);
        String protocol = KubernetesContext.workerTransportProtocol(config);
        V1Service service = new V1Service();
        service.setKind("Service");
        service.setApiVersion("v1");
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(serviceName);
        service.setMetadata(meta);
        V1ServiceSpec serviceSpec = new V1ServiceSpec();
        serviceSpec.setType("NodePort");
        HashMap<String, String> selectors = new HashMap<String, String>();
        selectors.put("app", serviceLabel);
        serviceSpec.setSelector(selectors);
        ArrayList<V1ServicePort> ports = new ArrayList<V1ServicePort>();
        V1ServicePort servicePort = new V1ServicePort();
        servicePort.setPort(Integer.valueOf(workerPort));
        servicePort.setProtocol(protocol);
        if (nodePort != 0) {
            servicePort.nodePort(Integer.valueOf(nodePort));
        }
        ports.add(servicePort);
        serviceSpec.setPorts(ports);
        service.setSpec(serviceSpec);
        return service;
    }

    public static V1PersistentVolume createPersistentVolumeObject(String pvName) {
        V1PersistentVolume pv = new V1PersistentVolume();
        pv.setApiVersion("v1");
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(pvName);
        pv.setMetadata(meta);
        V1PersistentVolumeSpec pvSpec = new V1PersistentVolumeSpec();
        HashMap capacity = new HashMap();
        pvSpec.setCapacity(capacity);
        String storageClass = KubernetesContext.persistentStorageClass(config);
        String accessMode = KubernetesContext.storageAccessMode(config);
        pvSpec.setStorageClassName(storageClass);
        pvSpec.setAccessModes(Arrays.asList(accessMode));
        V1NFSVolumeSource nfsVolumeSource = new V1NFSVolumeSource();
        nfsVolumeSource.setServer(SchedulerContext.nfsServerAddress((Config)config));
        nfsVolumeSource.setPath(SchedulerContext.nfsServerPath((Config)config));
        pvSpec.setNfs(nfsVolumeSource);
        pv.setSpec(pvSpec);
        return pv;
    }

    public static V1PersistentVolumeClaim createPersistentVolumeClaimObject(String pvcName, int numberOfWorkers) {
        V1PersistentVolumeClaim pvc = new V1PersistentVolumeClaim();
        pvc.setApiVersion("v1");
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(pvcName);
        pvc.setMetadata(meta);
        String storageClass = KubernetesContext.persistentStorageClass(config);
        String accessMode = KubernetesContext.storageAccessMode(config);
        V1PersistentVolumeClaimSpec pvcSpec = new V1PersistentVolumeClaimSpec();
        pvcSpec.setStorageClassName(storageClass);
        pvcSpec.setAccessModes(Arrays.asList(accessMode));
        V1ResourceRequirements resources = new V1ResourceRequirements();
        double storageSize = SchedulerContext.persistentVolumePerWorker((Config)config) * (double)numberOfWorkers;
        if (!JobMasterContext.jobMasterRunsInClient((Config)config)) {
            storageSize += JobMasterContext.persistentVolumeSize((Config)config);
        }
        resources.putRequestsItem("storage", new Quantity(storageSize + "Gi"));
        pvcSpec.setResources(resources);
        pvc.setSpec(pvcSpec);
        return pvc;
    }

    static {
        jobMasterIP = null;
        uploadMethod = "webserver";
    }
}

