/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.WorkerInfoUtils;
import edu.iu.dsc.tws.rsched.bootstrap.ZKWorkerController;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MesosWorkerController
implements IWorkerController {
    public static final Logger LOG = Logger.getLogger(MesosWorkerController.class.getName());
    private Config config;
    private String jobID;
    private JobAPI.Job job;
    private String workerIp;
    private int workerIdd;
    private int workerPort;
    private int numberOfWorkers;
    private int containerPerWorker;
    private List<JobMasterAPI.WorkerInfo> workerList;
    private JobMasterAPI.WorkerInfo thisWorker;
    private ZKWorkerController zkWorkerController;

    public MesosWorkerController(Config cfg, JobAPI.Job job, String ip, int port, int workerID) {
        this.config = cfg;
        this.jobID = job.getJobId();
        this.job = job;
        this.workerIp = ip;
        this.workerPort = port;
        this.workerIdd = workerID;
        this.numberOfWorkers = MesosContext.numberOfContainers(this.config) - 1;
        this.containerPerWorker = MesosContext.containerPerWorker(this.config);
        this.workerList = new ArrayList<JobMasterAPI.WorkerInfo>();
        this.thisWorker = WorkerInfoUtils.createWorkerInfo((int)workerID, (String)ip, (int)port, (JobMasterAPI.NodeInfo)SchedulerContext.getNodeInfo((Config)this.config, (String)ip));
    }

    public MesosWorkerController(Config cfg, JobAPI.Job job, String ip, int port, int workerID, JobAPI.ComputeResource computeResource, Map<String, Integer> additionalPorts) {
        this.config = cfg;
        this.jobID = job.getJobId();
        this.job = job;
        this.workerIp = ip;
        this.workerPort = port;
        this.workerIdd = workerID;
        this.numberOfWorkers = MesosContext.numberOfContainers(this.config) - 1;
        this.containerPerWorker = MesosContext.containerPerWorker(this.config);
        this.workerList = new ArrayList<JobMasterAPI.WorkerInfo>();
        this.thisWorker = WorkerInfoUtils.createWorkerInfo((int)workerID, (String)ip, (int)port, (JobMasterAPI.NodeInfo)SchedulerContext.getNodeInfo((Config)this.config, (String)ip), (JobAPI.ComputeResource)computeResource, additionalPorts);
    }

    private InetAddress convertStringToIP(String ipStr) {
        try {
            return InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Can not convert the IP to InetAddress: " + ipStr, e);
            throw new RuntimeException(e);
        }
    }

    public JobMasterAPI.WorkerInfo getWorkerInfo() {
        return this.thisWorker;
    }

    public JobMasterAPI.WorkerInfo getWorkerInfoForID(int id) {
        return null;
    }

    public int getNumberOfWorkers() {
        return this.job.getNumberOfWorkers();
    }

    public List<JobMasterAPI.WorkerInfo> getJoinedWorkers() {
        return this.zkWorkerController.getJoinedWorkers();
    }

    public void initializeWithZooKeeper() {
        long startTime = System.currentTimeMillis();
        String workerHostPort = this.workerIp + ":" + this.workerPort;
        JobMasterAPI.NodeInfo nodeInfo = MesosContext.getNodeInfo((Config)this.config, (String)this.workerIp);
        JobAPI.ComputeResource computeResource = null;
        this.zkWorkerController = new ZKWorkerController(this.config, this.job.getJobId(), workerHostPort, this.numberOfWorkers, nodeInfo, computeResource);
        this.zkWorkerController.initialize(this.workerIdd);
        long duration = System.currentTimeMillis() - startTime;
        LOG.info("Initialization for the worker: " + this.zkWorkerController.getWorkerInfo() + " took: " + duration + "ms");
    }

    public List<JobMasterAPI.WorkerInfo> getAllWorkers() throws TimeoutException {
        LOG.info("Waiting for " + this.numberOfWorkers + " workers to join .........");
        long startTime = System.currentTimeMillis();
        this.workerList = this.zkWorkerController.getAllWorkers();
        long duration = System.currentTimeMillis() - startTime;
        if (this.workerList == null) {
            LOG.log(Level.SEVERE, "Could not get full worker list. timeout limit has been reached !!!!");
        } else {
            LOG.log(Level.INFO, "Waited " + duration + " ms for all workers to join.");
            this.workerList = this.zkWorkerController.getJoinedWorkers();
            LOG.info("list of current workers in the job: ");
            this.zkWorkerController.printWorkers(this.workerList);
            LOG.info("list of all joined workers to the job: ");
            this.zkWorkerController.printWorkers(this.zkWorkerController.getJoinedWorkers());
        }
        return this.workerList;
    }

    public void waitOnBarrier() throws TimeoutException {
        this.zkWorkerController.waitOnBarrier();
    }

    public void close() {
        this.zkWorkerController.close();
    }
}

