/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.nomad.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadContext;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadController;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadTerminator;
import edu.iu.dsc.tws.rsched.utils.ResourceSchedulerUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NomadMasterStarter {
    private static final Logger LOG = Logger.getLogger(NomadMasterStarter.class.getName());
    private JobAPI.Job job;
    private Config config;

    public void initialize(JobAPI.Job jb, Config cfg) {
        this.job = jb;
        this.config = cfg;
    }

    public boolean launch() {
        String jobWorkingDirectory = NomadContext.workingDirectory(this.config);
        LOG.log(Level.INFO, "job working directory ....." + jobWorkingDirectory);
        if (NomadContext.sharedFileSystem(this.config) && !this.setupWorkingDirectory(this.job, jobWorkingDirectory)) {
            throw new RuntimeException("Failed to setup the directory");
        }
        Config newConfig = Config.newBuilder().putAll(this.config).put("twister2.working_directory", (Object)jobWorkingDirectory).build();
        NomadController controller = new NomadController(true);
        controller.initialize(newConfig);
        JobMaster jobMaster = null;
        Thread jmThread = null;
        if (JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            try {
                int port = JobMasterContext.jobMasterPort((Config)this.config);
                String hostAddress = JobMasterContext.jobMasterIP((Config)this.config);
                if (hostAddress == null) {
                    hostAddress = InetAddress.getLocalHost().getHostAddress();
                }
                LOG.log(Level.INFO, String.format("Starting the job manager: %s:%d", hostAddress, port));
                JobMasterAPI.NodeInfo jobMasterNodeInfo = NomadContext.getNodeInfo((Config)this.config, (String)hostAddress);
                IScalerPerCluster clusterScaler = null;
                JobMasterAPI.JobMasterState initialState = JobMasterAPI.JobMasterState.JM_STARTED;
                NomadTerminator nt = new NomadTerminator();
                jobMaster = new JobMaster(this.config, hostAddress, (IJobTerminator)nt, this.job, jobMasterNodeInfo, clusterScaler, initialState);
                jobMaster.addShutdownHook(true);
                jmThread = jobMaster.startJobMasterThreaded();
            }
            catch (UnknownHostException e) {
                LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
                throw new RuntimeException(e);
            }
            catch (Twister2Exception e) {
                LOG.log(Level.SEVERE, "Exception when starting Job master: ", e);
                throw new RuntimeException(e);
            }
        }
        boolean start = controller.start(this.job);
        if (JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            try {
                if (jmThread != null) {
                    jmThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return start;
    }

    private boolean setupWorkingDirectory(JobAPI.Job jb, String jobWorkingDirectory) {
        String corePackage = NomadContext.corePackageFileName((Config)this.config);
        String jobPackage = NomadContext.jobPackageFileName((Config)this.config);
        LOG.log(Level.INFO, "Core Package is ......: " + corePackage);
        LOG.log(Level.INFO, "Job Package is ......: " + jobPackage);
        String jobPackageURI = NomadContext.jobPackageUri((Config)this.config).toString();
        LOG.log(Level.INFO, "Job Package URI is ......: " + jobPackageURI);
        return ResourceSchedulerUtils.setupWorkingDirectory(jb.getJobName(), jobWorkingDirectory, corePackage, jobPackageURI, Context.verbose((Config)this.config));
    }
}

