/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPICommand;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIContext;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlurmCommand
extends MPICommand {
    private static final Logger LOG = Logger.getLogger(SlurmCommand.class.getName());
    private String jobIdFile = this.getJobIdFilePath();

    public SlurmCommand(Config cfg, String workingDirectory) {
        super(cfg, workingDirectory);
    }

    @Override
    protected String[] killCommand() {
        String file = this.getJobIdFilePath();
        List<String> jobIdFileContent = this.readFromFile(file);
        if (jobIdFileContent.size() > 0) {
            return new String[]{"scancel", jobIdFileContent.get(0)};
        }
        LOG.log(Level.SEVERE, "Failed to read the Slurm Job id from file: {0}", this.jobIdFile);
        return null;
    }

    @Override
    protected List<String> mpiCommand(String workingDirectory, JobAPI.Job job) {
        String twister2Home = Paths.get(workingDirectory, job.getJobId()).toString();
        String configDirectoryName = Paths.get(workingDirectory, job.getJobId(), SchedulerContext.clusterType((Config)this.config)).toString();
        String nodesFileName = MPIContext.nodeFiles(this.config);
        List<String> mpiCommand = this.mpiCommand(this.getScriptPath(), 1L, MPIContext.partition(this.config));
        Map<String, Object> map = this.mpiCommandArguments(this.config, job);
        mpiCommand.add(map.get("procs").toString());
        mpiCommand.add(map.get("java_props").toString());
        mpiCommand.add(map.get("classpath").toString());
        mpiCommand.add(map.get("container_class").toString());
        mpiCommand.add(job.getJobId());
        mpiCommand.add(twister2Home);
        mpiCommand.add(twister2Home);
        mpiCommand.add(MPIContext.mpiRunFile(this.config));
        mpiCommand.add("-Xmx" + this.getMemory(job) + "m");
        mpiCommand.add("-Xms" + this.getMemory(job) + "m");
        return mpiCommand;
    }

    protected String getJobIdFilePath() {
        return new File(this.workingDirectory, MPIContext.jobIdFile(this.config)).getPath();
    }

    private List<String> mpiCommand(String slurmScript, long containers, String partitionName) {
        String nTasks = String.format("--ntasks=%d", containers);
        String pName = String.format("--partition=%s", partitionName);
        ArrayList<String> slurmCmd = new ArrayList<String>(Arrays.asList("sbatch", "-N", Long.toString(containers), nTasks, pName, slurmScript));
        return slurmCmd;
    }
}

