/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone.bootstrap;

import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.ResourceSchedulerUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;
import mpi.MPI;
import mpi.MPIException;

public final class MPIBootstrap {
    private static final Logger LOG = Logger.getLogger(MPIBootstrap.class.getName());

    private MPIBootstrap() {
    }

    private static boolean exactFileExists(File file, String md5) throws IOException {
        return file.exists() && FileUtils.md5(file).equals(md5);
    }

    private static boolean allFilesExists(File[] files, String[] md5) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            if (MPIBootstrap.exactFileExists(files[i], md5[i])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws MPIException, IOException {
        File[] srcFiles;
        Thread.currentThread().setName("bootstrap");
        LOG.info("Initializing bootstrap procedure...");
        MPI.Init((String[])args);
        int rank = MPI.COMM_WORLD.getRank();
        String jobId = args[0];
        String jobWorkingDirectory = args[1];
        File jobFile = new File(args[2]);
        boolean copyCore = Boolean.parseBoolean(args[4]);
        File coreFile = new File(args[5]);
        LOG.info("Twister2 core will be copied : " + copyCore);
        LOG.info(String.format("[%d] Starting process of copying %s & %s of %s to %s", rank, jobFile.getAbsolutePath(), coreFile.getAbsolutePath(), jobId, jobWorkingDirectory));
        String[] md5s = new String[]{args[3], args[6]};
        if (copyCore) {
            srcFiles = new File[]{jobFile, coreFile};
            md5s = new String[]{args[3], args[6]};
        } else {
            srcFiles = new File[]{jobFile};
            md5s = new String[]{args[3]};
        }
        boolean[] resourceAvailability = new boolean[MPI.COMM_WORLD.getSize()];
        resourceAvailability[rank] = MPIBootstrap.allFilesExists(srcFiles, md5s);
        LOG.info(String.format("Resource availability of node %d : %b", rank, resourceAvailability[rank]));
        MPI.COMM_WORLD.allGather((Object)new boolean[]{resourceAvailability[rank]}, 1, MPI.BOOLEAN, (Object)resourceAvailability, 1, MPI.BOOLEAN);
        LOG.info("Communication find resource provider completed");
        int resourceProvider = 0;
        boolean allHaveFile = true;
        for (int i = 0; i < resourceAvailability.length; ++i) {
            if (resourceAvailability[i]) {
                resourceProvider = i;
            }
            allHaveFile = allHaveFile && resourceAvailability[i];
        }
        if (allHaveFile) {
            LOG.info("All members have the file. Exiting bootstrap procedure");
            MPIBootstrap.setupWorkingDirectory(jobId, jobWorkingDirectory, coreFile, jobFile, copyCore);
            MPI.Finalize();
            return;
        }
        LOG.info(String.format("%d has the resource files. Starting broadcast...", resourceProvider));
        byte[] buff = new byte[]{};
        int[] bufferSize = new int[1];
        for (File srcFile : srcFiles) {
            if (rank == resourceProvider) {
                buff = Files.readAllBytes(srcFile.toPath());
                bufferSize[0] = buff.length;
            }
            LOG.info(String.format("Exchanging buffer size of %s", srcFile.getName()));
            MPI.COMM_WORLD.bcast((Object)bufferSize, 1, MPI.INT, resourceProvider);
            if (rank != resourceProvider) {
                buff = new byte[bufferSize[0]];
            }
            LOG.info(String.format("Exchanging file %s", srcFile.getName()));
            MPI.COMM_WORLD.bcast((Object)buff, bufferSize[0], MPI.BYTE, resourceProvider);
            if (rank == resourceProvider) continue;
            srcFile.getParentFile().mkdirs();
            Files.write(srcFile.toPath(), buff, new OpenOption[0]);
        }
        MPIBootstrap.setupWorkingDirectory(jobId, jobWorkingDirectory, coreFile, jobFile, copyCore);
        LOG.info("Broadcasting completed");
        MPI.Finalize();
    }

    private static void setupWorkingDirectory(String jobId, String jobWorkingDirectory, File coreFile, File jobFile, boolean copyCore) {
        ResourceSchedulerUtils.setupWorkingDirectory(jobId, jobWorkingDirectory, coreFile.getName(), jobFile.getParentFile().getAbsolutePath(), true, copyCore);
    }
}

