/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.core;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.ILauncher;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.LauncherException;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.Twister2JobState;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.RequestObjectBuilder;
import edu.iu.dsc.tws.rsched.uploaders.scp.ScpContext;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import edu.iu.dsc.tws.rsched.utils.TarGzipPacker;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceAllocator {
    public static final Logger LOG = Logger.getLogger(ResourceAllocator.class.getName());
    private JobAPI.Job updatedJob;
    private Config updatedConfig;

    public static Config loadConfig(Map<String, Object> cfg) {
        String twister2Home = System.getProperty("twister2_home");
        String configDir = System.getProperty("config_dir");
        String clusterType = System.getProperty("cluster_type");
        String jobJar = System.getProperty("job_file");
        String jobType = System.getProperty("job_type");
        Boolean debug = Boolean.valueOf(System.getProperty("debug"));
        Map<String, Object> environmentProperties = JobUtils.readCommandLineOpts();
        if (environmentProperties.containsKey("twister2_home")) {
            twister2Home = (String)environmentProperties.get("config_dir");
        }
        if (environmentProperties.containsKey("config_dir")) {
            configDir = (String)environmentProperties.get("config_dir");
        }
        if (environmentProperties.containsKey("cluster_type")) {
            clusterType = (String)environmentProperties.get("cluster_type");
        }
        if (environmentProperties.containsKey("job_file")) {
            jobJar = (String)environmentProperties.get("job_file");
        }
        if (environmentProperties.containsKey("job_type")) {
            jobType = (String)environmentProperties.get("job_type");
        }
        if (configDir == null) {
            configDir = twister2Home + "/conf";
        }
        Config config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)clusterType);
        LOG.log(Level.INFO, String.format("Loaded configuration with twister2_home: %s and configuration: %s and cluster: %s", twister2Home, configDir, clusterType));
        return Config.newBuilder().putAll(config).put(SchedulerContext.TWISTER2_HOME.getKey(), (Object)twister2Home).put("twister2.cluster.type", (Object)clusterType).put("job_file", (Object)jobJar).put("job_type", (Object)jobType).put("debug", (Object)debug).putAll(environmentProperties).putAll(cfg).build();
    }

    public static Config getDefaultConfig() {
        return ResourceAllocator.loadConfig(new HashMap<String, Object>());
    }

    private String prepareJobFiles(Config config, JobAPI.Job job) {
        String jobJarFile = SchedulerContext.userJobJarFile((Config)config);
        if (jobJarFile == null) {
            throw new RuntimeException("Job file cannot be null");
        }
        Path tempDirPath = null;
        String tempDirPrefix = "twister2-" + job.getJobName() + "-";
        try {
            String jobArchiveTemp = SchedulerContext.jobArchiveTempDirectory((Config)config);
            tempDirPath = jobArchiveTemp != null ? Files.createTempDirectory(Paths.get(jobArchiveTemp, new String[0]), tempDirPrefix, new FileAttribute[0]) : Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp directory with the prefix: " + tempDirPrefix, e);
        }
        String tempDirPathString = tempDirPath.toString();
        if (!SchedulerContext.copySystemPackage((Config)config)) {
            LOG.log(Level.INFO, "No need to copy the systems package");
        } else {
            String twister2CorePackage = SchedulerContext.systemPackageUrl((Config)config);
            if (twister2CorePackage == null) {
                throw new RuntimeException("Core package is not specified in the configuration");
            }
            LOG.log(Level.INFO, String.format("Copy core package: %s to %s", twister2CorePackage, tempDirPathString));
            try {
                FileUtils.copyFileToDirectory(twister2CorePackage, tempDirPathString);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy the core package", e);
            }
        }
        TarGzipPacker packer = TarGzipPacker.createTarGzipPacker(tempDirPathString, config);
        if (packer == null) {
            throw new RuntimeException("Failed to created the archive file.");
        }
        String jobJarFileName = Paths.get(jobJarFile, new String[0]).getFileName().toString();
        JobAPI.JobFormat.Builder format = JobAPI.JobFormat.newBuilder();
        boolean ziped = false;
        String jobType = SchedulerContext.userJobType((Config)config);
        if ("jar".equals(jobType)) {
            format.setType(JobAPI.JobFormatType.JAR);
        } else if ("java_zip".equals(jobType)) {
            format.setType(JobAPI.JobFormatType.JAVA_ZIP);
            ziped = true;
        } else if ("python".equals(jobType)) {
            format.setType(JobAPI.JobFormatType.PYTHON);
        } else if ("python_zip".equals(jobType)) {
            ziped = true;
            format.setType(JobAPI.JobFormatType.PYTHON_ZIP);
        }
        format.setJobFile(jobJarFileName);
        this.updatedJob = JobAPI.Job.newBuilder((JobAPI.Job)job).setJobFormat(format).build();
        String jobDescFileName = SchedulerContext.createJobDescriptionFileName((String)job.getJobId());
        boolean added = packer.addFileToArchive(jobDescFileName, this.updatedJob.toByteArray());
        if (!added) {
            throw new RuntimeException("Failed to add the job description file to the archive: " + jobDescFileName);
        }
        added = !ziped ? packer.addFileToArchive(jobJarFile) : packer.addZipToArchive(jobJarFile);
        if (!added) {
            throw new RuntimeException("Failed to add the job jar file to the archive: " + jobJarFile);
        }
        String confDir = SchedulerContext.conf((Config)config);
        added = packer.addDirectoryToArchive(confDir);
        if (!added) {
            throw new RuntimeException("Failed to add the conf dir to the archive: " + confDir);
        }
        String commonConfDir = SchedulerContext.commonConfDir((Config)config);
        added = packer.addDirectoryToArchive(commonConfDir);
        if (!added) {
            throw new RuntimeException("Failed to add the conf dir to the archive: " + commonConfDir);
        }
        packer.close();
        LOG.log(Level.INFO, "Archive file created: " + packer.getArchiveFileName());
        this.updatedConfig = Config.newBuilder().putAll(config).put("job_file", (Object)jobJarFileName).put("temporary.packages.path", (Object)tempDirPathString).build();
        return tempDirPathString;
    }

    public Twister2JobState submitJob(JobAPI.Job job, Config config) {
        String scpServerAdress;
        IUploader uploader;
        ILauncher launcher;
        String jobDirectory = this.prepareJobFiles(config, job);
        String launcherClass = SchedulerContext.launcherClass((Config)config);
        if (launcherClass == null) {
            throw new RuntimeException("The launcher class must be specified");
        }
        String uploaderClass = SchedulerContext.uploaderClass((Config)config);
        if (uploaderClass == null) {
            throw new RuntimeException("The uploader class must be specified");
        }
        try {
            launcher = (ILauncher)ReflectionUtils.newInstance((ClassLoader)ResourceAllocator.class.getClassLoader(), (String)launcherClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new LauncherException(String.format("Failed to instantiate launcher class '%s'", launcherClass), (Throwable)e);
        }
        try {
            uploader = (IUploader)ReflectionUtils.newInstance((ClassLoader)ResourceAllocator.class.getClassLoader(), (String)uploaderClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UploaderException(String.format("Failed to instantiate uploader class '%s'", uploaderClass), (Throwable)e);
        }
        LOG.fine("Initialize uploader");
        uploader.initialize(this.updatedConfig, this.updatedJob);
        LOG.fine("Calling uploader to upload the job package");
        long start = System.currentTimeMillis();
        URI packageURI = uploader.uploadPackage(jobDirectory);
        long delay = System.currentTimeMillis() - start;
        LOG.info("Job package upload started. It took: " + delay + "ms");
        String scpPath = scpServerAdress = ScpContext.scpConnection(this.updatedConfig);
        if (packageURI != null) {
            scpPath = scpPath + ":" + packageURI.toString() + "/";
        }
        LOG.fine("SCP PATH to copy files from: " + scpPath);
        this.updatedConfig = Config.newBuilder().putAll(this.updatedConfig).put("twister2.packages.path", (Object)scpPath).put("twister2.job.package.uri", (Object)packageURI).build();
        launcher.initialize(this.updatedConfig);
        Twister2JobState state = launcher.launch(this.updatedJob);
        launcher.close();
        if (state.isRequestGranted()) {
            boolean transferred = uploader.complete();
            if (!transferred) {
                LOG.log(Level.SEVERE, "Transferring the job package failed.\n++++++++++++++++++ Aborting submission ++++++++++++++++++");
                launcher.terminateJob(job.getJobId());
                state.setRequestGranted(false);
            }
        } else {
            uploader.undo(this.updatedConfig, job.getJobId());
        }
        if (!(SchedulerContext.clusterType((Config)this.updatedConfig).equals("kubernetes") && SchedulerContext.uploaderClass((Config)this.updatedConfig).equals("edu.iu.dsc.tws.rsched.uploaders.k8s.K8sUploader") && RequestObjectBuilder.uploadMethod.equals("client-to-pods") && JobUtils.isJobScalable(this.updatedConfig, this.updatedJob))) {
            this.clearTemporaryFiles(jobDirectory);
        }
        return state;
    }

    public void clearTemporaryFiles(String jobDirectory) {
        String cleaningCommand = "rm -rf " + jobDirectory;
        System.out.println("cleaning  command:" + cleaningCommand);
        ProcessUtils.runSyncProcess(false, cleaningCommand.split(" "), new StringBuilder(), new File("."), true);
        LOG.log(Level.INFO, "CLEANED TEMPORARY DIRECTORY......:" + jobDirectory);
    }

    public void terminateJob(String jobID, Config config) {
        IUploader uploader;
        ILauncher launcher;
        String launcherClass = SchedulerContext.launcherClass((Config)config);
        if (launcherClass == null) {
            throw new RuntimeException("The launcher class must be specified");
        }
        try {
            launcher = (ILauncher)ReflectionUtils.newInstance((ClassLoader)ResourceAllocator.class.getClassLoader(), (String)launcherClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new LauncherException(String.format("Failed to instantiate launcher class '%s'", launcherClass), (Throwable)e);
        }
        launcher.initialize(config);
        boolean terminated = launcher.terminateJob(jobID);
        if (!terminated) {
            LOG.log(Level.SEVERE, "Could not terminate the job");
        }
        launcher.close();
        String uploaderClass = SchedulerContext.uploaderClass((Config)config);
        if (uploaderClass == null) {
            throw new RuntimeException("The uploader class must be specified");
        }
        try {
            uploader = (IUploader)ReflectionUtils.newInstance((ClassLoader)ResourceAllocator.class.getClassLoader(), (String)uploaderClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UploaderException(String.format("Failed to instantiate uploader class '%s'", uploaderClass), (Throwable)e);
        }
        uploader.undo(config, jobID);
        uploader.close();
    }
}

