/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.job;

import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.checkpointing.StateStore;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.scheduler.Twister2JobState;
import edu.iu.dsc.tws.checkpointing.util.CheckpointUtils;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingConfigurations;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.config.ConfigSerializer;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.core.ResourceAllocator;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public final class Twister2Submitter {
    private static final Logger LOG = Logger.getLogger(Twister2Submitter.class.getName());

    private Twister2Submitter() {
    }

    public static void submitJob(Twister2Job twister2Job) {
        Twister2Submitter.submitJob(twister2Job, ResourceAllocator.loadConfig((Map<String, Object>)twister2Job.getConfig()));
    }

    public static Twister2JobState submitJob(Twister2Job twister2Job, Config config) {
        boolean startingFromACheckpoint = CheckpointingConfigurations.startingFromACheckpoint((Config)config);
        if (!startingFromACheckpoint) {
            switch (Context.clusterType((Config)config)) {
                case "kubernetes": {
                    break;
                }
                case "mesos": 
                case "nomad": {
                    twister2Job.setJobName(twister2Job.getJobName() + System.currentTimeMillis());
                    break;
                }
            }
        }
        twister2Job.setJobID(Context.jobId((Config)config));
        String userName = Context.userName((Config)config);
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        twister2Job.setUserName(userName);
        JobAPI.Job job = twister2Job.serialize();
        LOG.info("The job to be submitted: \n" + JobUtils.toString(job));
        Config updatedConfig = JobUtils.updateConfigs(job, config);
        String jobId = job.getJobId();
        String dir = System.getProperty("user.home") + "/.twister2";
        if (!FileUtils.isDirectoryExists(dir)) {
            FileUtils.createDirectory(dir);
        }
        String filename = dir + "/last-job-id.txt";
        FileUtils.writeToFile(filename, (jobId + "").getBytes(), true);
        LOG.info("\n\n _____           _     _           ____  \n/__   \\__      _(_)___| |_ ___ _ _|___ \\ \n  / /\\/\\ \\ /\\ / / / __| __/ _ \\ '__|__) |\n / /    \\ V  V /| \\__ \\ ||  __/ |  / __/ \n \\/      \\_/\\_/ |_|___/\\__\\___|_| |_____| v0.6.0\n                                         \nJob Name\t:\t" + job.getJobName() + "\nJob ID\t\t:\t" + jobId + "\nCluster Type\t:\t" + Context.clusterType((Config)config) + "\nRuntime\t\t:\t" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "\n\n");
        if (CheckpointingConfigurations.isCheckpointingEnabled((Config)updatedConfig)) {
            LOG.info("Checkpointing has enabled for this job.");
            StateStore stateStore = CheckpointUtils.getStateStore((Config)updatedConfig);
            stateStore.init(updatedConfig, new String[]{job.getJobId()});
            try {
                if (startingFromACheckpoint) {
                    if (!CheckpointUtils.containsJobInStore((String)job.getJobId(), (StateStore)stateStore)) {
                        throw new RuntimeException("Couldn't find job state in store to restart " + jobId);
                    }
                    LOG.info("Found job " + jobId + " in state store. Restoring...");
                    byte[] jobMetaBytes = CheckpointUtils.restoreJobMeta((String)jobId, (StateStore)stateStore);
                    job = JobAPI.Job.parseFrom((byte[])jobMetaBytes);
                    byte[] configBytes = CheckpointUtils.restoreJobConfig((String)jobId, (StateStore)stateStore);
                    updatedConfig = ConfigLoader.loadConfig((byte[])configBytes);
                } else {
                    LOG.info("Saving job config and metadata");
                    CheckpointUtils.saveJobConfigAndMeta((String)jobId, (byte[])job.toByteArray(), (byte[])ConfigSerializer.serialize((Config)updatedConfig), (StateStore)stateStore);
                }
            }
            catch (IOException e) {
                LOG.severe("Failed to submit th checkpointing enabled job");
                throw new RuntimeException(e);
            }
        }
        ResourceAllocator resourceAllocator = new ResourceAllocator();
        return resourceAllocator.submitJob(job, updatedConfig);
    }

    public static void terminateJob(String jobID, Config config) {
        ResourceAllocator resourceAllocator = new ResourceAllocator();
        resourceAllocator.terminateJob(jobID, config);
    }
}

