/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.worker;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.faulttolerance.FaultToleranceContext;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.logging.LoggingContext;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKPersStateManager;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sPersistentVolume;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;

public final class K8sWorkerUtils {
    private static final Logger LOG = Logger.getLogger(K8sWorkerUtils.class.getName());

    private K8sWorkerUtils() {
    }

    public static Config loadConfig(String configDir) {
        String twister2Home = Paths.get("", new String[0]).toAbsolutePath().toString();
        LOG.info(String.format("Loading configuration with twister2_home: %s and configuration: %s", twister2Home, configDir));
        Config conf1 = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)"kubernetes");
        LOG.info("Loaded: " + conf1.size() + " parameters from configuration directory: " + configDir);
        Config conf2 = Config.newBuilder().putAll(conf1).put(Context.TWISTER2_HOME.getKey(), (Object)twister2Home).put(Context.TWISTER2_CONF.getKey(), (Object)configDir).put("twister2.cluster.type", (Object)"kubernetes").build();
        return conf2;
    }

    public static void initWorkerLogger(int workerID, K8sPersistentVolume pv, Config cnfg) {
        if (pv != null && LoggingContext.fileLoggingRequested()) {
            if (LoggingContext.redirectSysOutErr()) {
                LOG.warning("Redirecting System.out and System.err to the log file. Check the log file for the upcoming log messages. ");
            }
            String logFile = "worker-" + workerID;
            LoggingHelper.setupLogging((Config)cnfg, (String)pv.getLogDirPath(), (String)logFile);
            LOG.info("Persistent logging to file initialized.");
        }
    }

    public static void initLogger(Config cnfg, String entityName) {
        if ("jobMaster".equalsIgnoreCase(entityName) && !JobMasterContext.persistentVolumeRequested((Config)cnfg)) {
            return;
        }
        if ("mpiMaster".equalsIgnoreCase(entityName) && !KubernetesContext.persistentVolumeRequested((Config)cnfg)) {
            return;
        }
        if (LoggingContext.fileLoggingRequested()) {
            if (LoggingContext.redirectSysOutErr()) {
                LOG.warning("Redirecting System.out and System.err to the log file. Check the log file for the upcoming log messages. ");
            }
            String logDirName = "/persistent/logs";
            File logDir = new File(logDirName);
            logDir.getParentFile().list();
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            String logFileName = entityName;
            LoggingHelper.setupLogging((Config)cnfg, (String)logDirName, (String)logFileName);
            String logFileWithPath = logDirName + "/" + logFileName + ".log.0";
            LOG.info("Persistent logging to file initialized: " + logFileWithPath);
        }
    }

    public static JobAPI.ComputeResource getComputeResource(JobAPI.Job job, String podName) {
        String ssName = KubernetesUtils.removeIndexFromName(podName);
        int currentStatefulSetIndex = KubernetesUtils.indexFromName(ssName);
        return JobUtils.getComputeResource(job, currentStatefulSetIndex);
    }

    public static int calculateWorkerID(JobAPI.Job job, String podName, String containerName) {
        String ssName = KubernetesUtils.removeIndexFromName(podName);
        int currentStatefulSetIndex = KubernetesUtils.indexFromName(ssName);
        int workersUpToSS = K8sWorkerUtils.countWorkersUpToSS(job, currentStatefulSetIndex);
        int podIndex = KubernetesUtils.indexFromName(podName);
        int containerIndex = KubernetesUtils.indexFromName(containerName);
        int workersPerPod = JobUtils.getComputeResource(job, currentStatefulSetIndex).getWorkersPerPod();
        int workerID = workersUpToSS + K8sWorkerUtils.calculateWorkerIDInSS(podIndex, containerIndex, workersPerPod);
        return workerID;
    }

    public static int countWorkersUpToSS(JobAPI.Job job, int currentStatefulSetIndex) {
        int workerCount = 0;
        for (int i = 0; i < currentStatefulSetIndex; ++i) {
            JobAPI.ComputeResource computeResource = JobUtils.getComputeResource(job, i);
            workerCount += computeResource.getInstances() * computeResource.getWorkersPerPod();
        }
        return workerCount;
    }

    public static int calculateWorkerIDInSS(int podIndex, int containerIndex, int workersPerPod) {
        return podIndex * workersPerPod + containerIndex;
    }

    public static JobMasterAPI.NodeInfo getNodeInfoFromEncodedStr(String encodedNodeInfoList, String nodeIP) {
        JobMasterAPI.NodeInfo nodeInfo = NodeInfoUtils.createNodeInfo((String)nodeIP, null, null);
        ArrayList nodeInfoList = NodeInfoUtils.decodeNodeInfoList((String)encodedNodeInfoList);
        if (nodeInfoList == null || nodeInfoList.size() == 0) {
            LOG.warning("NodeInfo list is not constructed from the string: " + encodedNodeInfoList);
            return nodeInfo;
        }
        LOG.fine("Decoded NodeInfo list, size: " + nodeInfoList.size() + "\n" + NodeInfoUtils.listToString((ArrayList)nodeInfoList));
        JobMasterAPI.NodeInfo nodeInfo1 = NodeInfoUtils.getNodeInfo((ArrayList)nodeInfoList, (String)nodeIP);
        if (nodeInfo1 == null) {
            LOG.warning("nodeIP does not exist in received encodedNodeInfoList. Using local value.");
            return nodeInfo;
        }
        return nodeInfo1;
    }

    public static String getJobMasterServiceIP(String namespace, String jobID) {
        String jobMasterServiceName = KubernetesUtils.createJobMasterServiceName(jobID);
        jobMasterServiceName = jobMasterServiceName + "." + namespace + ".svc.cluster.local";
        try {
            return InetAddress.getByName(jobMasterServiceName).getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.info("Cannot get Job master IP from service name: " + jobMasterServiceName);
            return null;
        }
    }

    public static String getJobMasterServiceIPByPolling(String namespace, String jobID, long timeLimitMS) {
        long logInterval;
        String jmServiceName = KubernetesUtils.createJobMasterServiceName(jobID);
        jmServiceName = jmServiceName + "." + namespace + ".svc.cluster.local";
        long sleepInterval = 100L;
        long startTime = System.currentTimeMillis();
        long duration = 0L;
        long nextLogTime = logInterval = 1000L;
        while (duration < timeLimitMS) {
            try {
                InetAddress jmAddress = InetAddress.getByName(jmServiceName);
                return jmAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.fine("Cannot get Job master IP from service name.");
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException e2) {
                    LOG.warning("Sleep interrupted.");
                }
                sleepInterval += 10L;
                duration = System.currentTimeMillis() - startTime;
                if (duration <= nextLogTime) continue;
                LOG.info("Still trying to get Job Master IP address for the service:  " + jmServiceName);
                nextLogTime += logInterval;
            }
        }
        return null;
    }

    public static Map<String, Integer> generateAdditionalPorts(Config config, int workerPort) {
        List portNames = SchedulerContext.additionalPorts((Config)config);
        if (portNames == null) {
            return null;
        }
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        int i = 1;
        for (String portName : portNames) {
            ports.put(portName, workerPort + i++);
        }
        return ports;
    }

    public static void waitIndefinitely() {
        while (true) {
            try {
                while (true) {
                    LOG.info("Worker completed. Waiting idly to be deleted by Job Master. Sleeping 100sec. Time: " + new Date());
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
                continue;
            }
            break;
        }
    }

    public static JobMasterAPI.WorkerState initialStateAndUpdate(Config cnfg, String jbID, JobMasterAPI.WorkerInfo wInfo) {
        if (ZKContext.isZooKeeperServerUsed((Config)cnfg)) {
            String zkServerAddresses = ZKContext.serverAddresses((Config)cnfg);
            int sessionTimeoutMs = FaultToleranceContext.sessionTimeout((Config)cnfg);
            CuratorFramework client = ZKUtils.connectToServer((String)zkServerAddresses, (int)sessionTimeoutMs);
            String rootPath = ZKContext.rootNode((Config)cnfg);
            try {
                if (ZKPersStateManager.isWorkerRestarting((CuratorFramework)client, (String)rootPath, (String)jbID, (JobMasterAPI.WorkerInfo)wInfo)) {
                    return JobMasterAPI.WorkerState.RESTARTED;
                }
                if (ZKPersStateManager.checkPersDirWaitIfNeeded((CuratorFramework)client, (String)rootPath, (String)jbID)) {
                    ZKPersStateManager.createWorkerPersState((CuratorFramework)client, (String)rootPath, (String)jbID, (JobMasterAPI.WorkerInfo)wInfo);
                }
                return JobMasterAPI.WorkerState.STARTED;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not get initial state for the worker. Assuming WorkerState.STARTED", e);
                return JobMasterAPI.WorkerState.STARTED;
            }
        }
        return JobMasterAPI.WorkerState.STARTED;
    }
}

