/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos;

import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import java.io.File;

public class MesosPersistentVolume
implements IPersistentVolume {
    public static final String WORKER_DIR_NAME_PREFIX = "worker-";
    public static final String LOG_FILE_NAME_PREFIX = "worker-";
    public static final String LOG_DIR_NAME = "/logs";
    private String jobDirPath;
    private String workerDirPath;
    private String logFileName;
    private String logDirPath;

    public MesosPersistentVolume(String jobDirPath, int workerID) {
        this.jobDirPath = jobDirPath;
        this.workerDirPath = jobDirPath + "/" + "worker-" + workerID;
        this.logDirPath = jobDirPath + LOG_DIR_NAME;
        this.logFileName = this.logDirPath + "/" + "worker-" + workerID + ".log";
        this.createLogDir();
    }

    private void createLogDir() {
        File logDir = new File(this.logDirPath);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
    }

    public String getJobDirPath() {
        return this.jobDirPath;
    }

    public String getWorkerDirPath() {
        return this.workerDirPath;
    }

    public boolean jobDirExists() {
        return new File(this.jobDirPath).exists();
    }

    public boolean workerDirExists() {
        return new File(this.workerDirPath).exists();
    }

    public File getJobDir() {
        File dir = new File(this.jobDirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public File getWorkerDir() {
        if (!this.jobDirExists()) {
            return null;
        }
        File workerDir = new File(this.workerDirPath);
        if (workerDir.exists()) {
            return workerDir;
        }
        workerDir.mkdir();
        return workerDir;
    }

    public String getLogFileName() {
        return this.logFileName;
    }
}

