/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.logging.LoggingContext;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerController;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mesos.Executor;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.MesosExecutorDriver;
import org.apache.mesos.Protos;

public class MesosWorker
implements Executor {
    public static final Logger LOG = Logger.getLogger(MesosWorker.class.getName());
    private static int executorCounter = 0;
    private Config config;
    private String jobID;

    public void registered(ExecutorDriver executorDriver, Protos.ExecutorInfo executorInfo, Protos.FrameworkInfo frameworkInfo, Protos.SlaveInfo slaveInfo) {
    }

    public void reregistered(ExecutorDriver executorDriver, Protos.SlaveInfo slaveInfo) {
    }

    public void disconnected(ExecutorDriver executorDriver) {
    }

    public void launchTask(ExecutorDriver executorDriver, Protos.TaskInfo taskInfo) {
        IWorker container;
        LOG.info("Task start time(ms):" + System.currentTimeMillis());
        Integer id = Integer.parseInt(taskInfo.getData().toStringUtf8());
        LOG.info("Task " + id + " has started");
        Protos.TaskStatus status = Protos.TaskStatus.newBuilder().setTaskId(taskInfo.getTaskId()).setState(Protos.TaskState.TASK_RUNNING).build();
        executorDriver.sendStatusUpdate(status);
        String workerClass = SchedulerContext.workerClass((Config)this.config);
        try {
            Object object = ReflectionUtils.newInstance((String)workerClass);
            container = (IWorker)object;
            LOG.info("loaded worker class: " + workerClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.log(Level.SEVERE, String.format("failed to load the worker class %s", workerClass), e);
            throw new RuntimeException(e);
        }
        long port = 0L;
        for (Protos.Resource r : taskInfo.getResourcesList()) {
            if (!r.getName().equals("ports")) continue;
            port = r.getRanges().getRange(0).getBegin();
            break;
        }
        try {
            JobAPI.Job job = JobUtils.readJobFile(null, "twister2-job/" + this.jobID + ".job");
            MesosWorkerController workerController = new MesosWorkerController(this.config, job, InetAddress.getLocalHost().getHostAddress(), Math.toIntExact(port), id);
            LOG.info("Initializing with zookeeper");
            workerController.initializeWithZooKeeper();
            LOG.info("Waiting for all workers to join");
            workerController.getAllWorkers();
            LOG.info("Everyone has joined");
            container.execute(this.config, id.intValue(), (IWorkerController)workerController, null, null);
            workerController.close();
        }
        catch (UnknownHostException e) {
            LOG.severe("Host unkown " + e.getMessage());
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, timeoutException.getMessage(), timeoutException);
            return;
        }
        LOG.info("Task " + id + " has finished");
        status = Protos.TaskStatus.newBuilder().setTaskId(taskInfo.getTaskId()).setState(Protos.TaskState.TASK_FINISHED).build();
        executorDriver.sendStatusUpdate(status);
    }

    public void killTask(ExecutorDriver executorDriver, Protos.TaskID taskID) {
    }

    public void frameworkMessage(ExecutorDriver executorDriver, byte[] bytes) {
    }

    public void shutdown(ExecutorDriver executorDriver) {
    }

    public void error(ExecutorDriver executorDriver, String s) {
    }

    public static void main(String[] args) throws Exception {
        MesosWorker worker = new MesosWorker();
        String twister2Home = Paths.get("", new String[0]).toAbsolutePath().toString();
        String configDir = "twister2-job";
        worker.config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)"mesos");
        LoggingHelper.setLoggingFormat((String)"[%1$tF %1$tT] [%4$s] [%7$s] %3$s: %5$s %6$s %n");
        worker.jobID = args[0];
        String workerName = args[1];
        MesosWorker.initLogging(worker.config, SchedulerContext.nfsServerPath((Config)worker.config) + "/" + worker.jobID + "/logs", workerName);
        System.out.println(worker.config);
        MesosExecutorDriver driver = new MesosExecutorDriver((Executor)worker);
        driver.run();
    }

    public static void initLogging(Config cnfg, String logDir, String logFileName) {
        if (LoggingContext.fileLoggingRequested()) {
            if (LoggingContext.redirectSysOutErr()) {
                LOG.warning("Redirecting System.out and System.err to the log file. Check the log file for the upcoming log messages. ");
            }
            LoggingHelper.setupLogging((Config)cnfg, (String)logDir, (String)logFileName);
            LOG.info("Persistent logging to file initialized.");
        }
    }
}

