/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProcessUtils {
    private static final Logger LOG = Logger.getLogger(ProcessUtils.class.getName());

    private ProcessUtils() {
    }

    protected static ProcessBuilder getProcessBuilder(boolean isInheritIO, String[] command, File workingDirectory, Map<String, String> envs) {
        ProcessBuilder pb = new ProcessBuilder(command).directory(workingDirectory);
        if (isInheritIO) {
            pb.inheritIO();
        }
        Map<String, String> env = pb.environment();
        for (String envKey : envs.keySet()) {
            env.put(envKey, envs.get(envKey));
        }
        return pb;
    }

    public static int runProcess(String cmdline, StringBuilder outputBuilder, boolean isVerbose) {
        return ProcessUtils.runSyncProcess(true, ProcessUtils.splitTokens(cmdline), outputBuilder, null, isVerbose);
    }

    public static int runSyncProcess(boolean isInheritIO, String[] cmdline, StringBuilder outputBuilder, File workingDirectory, boolean isVerbose) {
        return ProcessUtils.runSyncProcess(isInheritIO, cmdline, outputBuilder, workingDirectory, new HashMap<String, String>(), isVerbose);
    }

    private static Thread createAsyncStreamThread(final InputStream input, StringBuilder processOutputStringBuilder, final boolean isVerbose) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input), 1);
                while (true) {
                    String line = null;
                    try {
                        line = reader.readLine();
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Error when reading line from subprocess", e);
                    }
                    if (line == null) break;
                    if (!isVerbose) continue;
                    System.err.println(line);
                }
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to close the input stream", e);
                }
            }
        };
        thread.setDaemon(true);
        return thread;
    }

    private static int runSyncProcess(boolean isInheritIO, String[] cmdline, StringBuilder outputBuilder, File workingDirectory, Map<String, String> envs, boolean isVerbose) {
        Process process;
        StringBuilder builder = outputBuilder == null ? new StringBuilder() : outputBuilder;
        LOG.log(Level.FINER, "Running synced process: ``{0}''''", ProcessUtils.joinString(cmdline));
        ProcessBuilder pb = ProcessUtils.getProcessBuilder(isInheritIO, cmdline, workingDirectory, envs);
        pb.redirectErrorStream(true);
        try {
            process = pb.start();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to run synced process", e);
            return -1;
        }
        Thread outputsThread = ProcessUtils.createAsyncStreamThread(process.getInputStream(), builder, isVerbose);
        try {
            outputsThread.start();
            int exitValue = process.waitFor();
            outputsThread.join();
            return exitValue;
        }
        catch (InterruptedException e) {
            outputsThread.interrupt();
            process.destroy();
            LOG.log(Level.SEVERE, "Running synced process was interrupted", e);
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public static Process runASyncProcess(String[] command, File workingDirectory, String logFileUuid) {
        return ProcessUtils.runASyncProcess(command, workingDirectory, new HashMap<String, String>(), logFileUuid, true);
    }

    public static Process runASyncProcess(boolean verbose, String[] command, File workingDirectory) {
        return ProcessUtils.runASyncProcess(command, workingDirectory, new HashMap<String, String>(), null, true);
    }

    public static Process runASyncProcess(boolean verbose, String[] command, File workingDirectory, Map<String, String> envs) {
        return ProcessUtils.runASyncProcess(command, workingDirectory, envs, null, true);
    }

    public static Process runASyncProcess(String command) {
        return ProcessUtils.runASyncProcess(ProcessUtils.splitTokens(command), new File("."), new HashMap<String, String>(), null, false);
    }

    private static Process runASyncProcess(String[] command, File workingDirectory, Map<String, String> envs, String logFileUuid, boolean logStderr) {
        LOG.log(Level.INFO, "Running async process: ``{0}''''", ProcessUtils.joinString(command));
        String commandFileName = Paths.get(command[0], new String[0]).getFileName().toString();
        String uuid = logFileUuid;
        if (uuid == null) {
            uuid = UUID.randomUUID().toString().substring(0, 8) + "-started";
        }
        ProcessBuilder pb = ProcessUtils.getProcessBuilder(false, command, workingDirectory, envs);
        pb.redirectErrorStream(true);
        if (logStderr) {
            String logFilePath = String.format("%s/%s-%s.stderr", workingDirectory, commandFileName, uuid);
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(logFilePath)));
        }
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to run async process", e);
        }
        return process;
    }

    public static boolean curlPackage(String uri, String destination, boolean isVerbose, boolean isInheritIO) {
        File parentDirectory = Paths.get(destination, new String[0]).getParent().toFile();
        String cmd = String.format("curl %s -o %s", uri, destination);
        int ret = ProcessUtils.runSyncProcess(isInheritIO, ProcessUtils.splitTokens(cmd), new StringBuilder(), parentDirectory, isVerbose);
        return ret == 0;
    }

    public static boolean extractPackage(String packageName, String targetFolder, boolean isVerbose, boolean isInheritIO) {
        String cmd = String.format("tar -xvf %s", packageName);
        int ret = ProcessUtils.runSyncProcess(isInheritIO, ProcessUtils.splitTokens(cmd), new StringBuilder(), new File(targetFolder), isVerbose);
        return ret == 0;
    }

    public static boolean extractPackageWithoutDir(String packageName, String targetFolder, boolean isVerbose, boolean isInheritIO) {
        String cmd = String.format("tar -xvf %s --strip-components 1", packageName);
        int ret = ProcessUtils.runSyncProcess(isInheritIO, ProcessUtils.splitTokens(cmd), new StringBuilder(), new File(targetFolder), isVerbose);
        return ret == 0;
    }

    public static boolean createTarPackage(String packageName, String outputName, String targetFolder, boolean isVerbose, boolean isInheritIO) {
        String cmd = String.format("tar -cvf %s %s", packageName, outputName);
        int ret = ProcessUtils.runSyncProcess(isInheritIO, ProcessUtils.splitTokens(cmd), new StringBuilder(), new File(targetFolder), isVerbose);
        return ret == 0;
    }

    private static String joinString(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (String value : array) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    protected static String[] splitTokens(String command) {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return cmdarray;
    }
}

