/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.utils;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class TarGzipPacker {
    public static final Logger LOG = Logger.getLogger(TarGzipPacker.class.getName());
    private TarArchiveOutputStream tarOutputStream;
    private Path archiveFile;

    private TarGzipPacker(Path archiveFile, TarArchiveOutputStream tarOutputStream) {
        this.archiveFile = archiveFile;
        this.tarOutputStream = tarOutputStream;
    }

    public static TarGzipPacker createTarGzipPacker(String targetDir, Config config) {
        String archiveFilename = SchedulerContext.jobPackageFileName((Config)config);
        Path archiveFile = Paths.get(targetDir + "/" + archiveFilename, new String[0]);
        try {
            OutputStream outStream = Files.newOutputStream(archiveFile, new OpenOption[0]);
            GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream(outStream);
            TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream((OutputStream)gzipOutputStream);
            return new TarGzipPacker(archiveFile, tarOutputStream);
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Archive file can not be created: " + archiveFile, ioe);
            return null;
        }
    }

    public String getArchiveFileName() {
        return this.archiveFile.toString();
    }

    public boolean addTarGzipToArchive(String tarGzipFile) {
        try {
            ArchiveEntry nextEntry;
            InputStream fin = Files.newInputStream(Paths.get(tarGzipFile, new String[0]), new OpenOption[0]);
            BufferedInputStream in = new BufferedInputStream(fin);
            GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
            TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)gzIn);
            while ((nextEntry = tarInputStream.getNextEntry()) != null) {
                this.tarOutputStream.putArchiveEntry(nextEntry);
                IOUtils.copy((InputStream)tarInputStream, (OutputStream)this.tarOutputStream);
                this.tarOutputStream.closeArchiveEntry();
            }
            tarInputStream.close();
            return true;
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Archive File can not be added: " + tarGzipFile, ioe);
            return false;
        }
    }

    public boolean addZipToArchive(String zipFile) {
        return this.addZipToArchive(zipFile, "twister2-job" + File.separator);
    }

    public boolean addZipToArchive(String zipFile, String dirPrefixForTar) {
        try {
            ZipFile zipFileObj = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zipFileObj.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextEntry = entries.nextElement();
                TarArchiveEntry entry = new TarArchiveEntry(dirPrefixForTar + nextEntry.getName());
                entry.setSize(nextEntry.getSize());
                entry.setModTime(nextEntry.getTime());
                this.tarOutputStream.putArchiveEntry((ArchiveEntry)entry);
                IOUtils.copy((InputStream)zipFileObj.getInputStream(nextEntry), (OutputStream)this.tarOutputStream);
                this.tarOutputStream.closeArchiveEntry();
            }
            zipFileObj.close();
            return true;
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Archive File can not be added: " + zipFile, ioe);
            return false;
        }
    }

    public boolean addFileToArchive(String filename) {
        File file = new File(filename);
        return this.addFileToArchive(file, "twister2-job/");
    }

    public boolean addFileToArchive(File file, String dirPrefixForTar) {
        try {
            String filePathInTar = dirPrefixForTar + file.getName();
            TarArchiveEntry entry = new TarArchiveEntry(file, filePathInTar);
            entry.setSize(file.length());
            this.tarOutputStream.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)this.tarOutputStream);
            this.tarOutputStream.closeArchiveEntry();
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "File can not be added: " + file.getName(), e);
            return false;
        }
    }

    public boolean addDirectoryToArchive(String path) {
        File dir = new File(path);
        String prefix = "twister2-job/" + dir.getName() + "/";
        for (File file : dir.listFiles()) {
            boolean added;
            if (file.isDirectory() || (added = this.addFileToArchive(file, prefix))) continue;
            return false;
        }
        return true;
    }

    public boolean addFileToArchive(String filename, byte[] contents) {
        String filePathInTar = "twister2-job/" + filename;
        try {
            TarArchiveEntry entry = new TarArchiveEntry(filePathInTar);
            entry.setSize((long)contents.length);
            this.tarOutputStream.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)new ByteArrayInputStream(contents), (OutputStream)this.tarOutputStream);
            this.tarOutputStream.closeArchiveEntry();
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "File can not be added: " + filePathInTar, e);
            return false;
        }
    }

    public void close() {
        try {
            this.tarOutputStream.finish();
            this.tarOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean unpack(String sourceGzip) {
        File sourceGzipFile = new File(sourceGzip);
        File outputDir = sourceGzipFile.getParentFile();
        return TarGzipPacker.unpack(sourceGzip, outputDir);
    }

    public static boolean unpack(String sourceGzip, File outputDir) {
        GzipCompressorInputStream gzIn = null;
        TarArchiveInputStream tarInputStream = null;
        try {
            InputStream fin = Files.newInputStream(Paths.get(sourceGzip, new String[0]), new OpenOption[0]);
            BufferedInputStream in = new BufferedInputStream(fin);
            gzIn = new GzipCompressorInputStream((InputStream)in);
            tarInputStream = new TarArchiveInputStream((InputStream)gzIn);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)tarInputStream.getNextEntry()) != null) {
                boolean dirCreated;
                File outputFile = new File(outputDir, entry.getName());
                if (!outputFile.getParentFile().exists() && !(dirCreated = outputFile.getParentFile().mkdirs())) {
                    LOG.severe("Can not create the output directory: " + outputFile.getParentFile() + "\nFile unpack is unsuccessful.");
                    return false;
                }
                if (outputFile.isDirectory()) continue;
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)tarInputStream, (OutputStream)outputFileStream);
                ((OutputStream)outputFileStream).close();
            }
            tarInputStream.close();
            gzIn.close();
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when unpacking job package. ", e);
            return false;
        }
    }
}

