/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.comms.Op;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.compute.IFunction;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.ops.AbstractKeyedOpsConfig;
import edu.iu.dsc.tws.task.impl.ops.ReduceConfig;

public class KeyedReduceConfig
extends AbstractKeyedOpsConfig<KeyedReduceConfig> {
    private IFunction redFunction;
    private Op op;

    public KeyedReduceConfig(String parent, ComputeConnection computeConnection) {
        super(parent, "keyed_reduce", computeConnection);
    }

    public <T> KeyedReduceConfig withReductionFunction(Class<T> tClass, IFunction<T> reductionFunction) {
        this.redFunction = reductionFunction;
        return this;
    }

    public KeyedReduceConfig withReductionFunction(IFunction reductionFunction) {
        this.redFunction = reductionFunction;
        return this;
    }

    public KeyedReduceConfig withOperation(Op operation, MessageType dataType) {
        this.op = operation;
        return (KeyedReduceConfig)this.withDataType(dataType);
    }

    @Override
    void validate() {
        ReduceConfig.validateReduce(this.redFunction, this.op, this.getOpDataType());
    }

    @Override
    protected Edge updateEdge(Edge newEdge) {
        ReduceConfig.updateReduceEdge(newEdge, this.redFunction, this.op, this.getOpDataType());
        return newEdge;
    }
}

