/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.eviction.duration;

import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.constant.Action;
import edu.iu.dsc.tws.task.window.policy.eviction.duration.DurationEvictionPolicy;
import java.util.logging.Logger;

public class WatermarkDurationEvictionPolicy<T>
extends DurationEvictionPolicy<T> {
    private static final Logger LOG = Logger.getLogger(WatermarkDurationEvictionPolicy.class.getName());
    private final long lag;

    public WatermarkDurationEvictionPolicy(long winLength) {
        this(winLength, Long.MAX_VALUE);
    }

    public WatermarkDurationEvictionPolicy(long winLength, long lag) {
        super(winLength);
        this.lag = lag;
        this.referenceTime = 0L;
    }

    @Override
    public Action evict(Event<T> event) {
        if (this.evictionContext == null) {
            return Action.STOP;
        }
        long referenceTime = this.evictionContext.getReferenceTime();
        long diff = referenceTime - event.getTimeStamp();
        if (diff < -this.lag) {
            return Action.STOP;
        }
        if (diff < 0L) {
            return Action.KEEP;
        }
        return super.evict(event);
    }

    @Override
    public String toString() {
        return "WatermarkDurationEvictionPolicy{lag=" + this.lag + ", referenceTime=" + this.referenceTime + '}' + super.toString();
    }
}

