/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.trigger.duration;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import edu.iu.dsc.tws.task.window.api.DefaultEvictionContext;
import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.api.IEvictionPolicy;
import edu.iu.dsc.tws.task.window.manage.IManager;
import edu.iu.dsc.tws.task.window.policy.trigger.IWindowingPolicy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class DurationWindowPolicy<T>
implements IWindowingPolicy<T> {
    private static final Logger LOG = Logger.getLogger(DurationWindowPolicy.class.getName());
    private static final long TIMEOUT = 2L;
    private static final long TRIGGER_CALL_TIME = 1L;
    private long duration;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> executorFuture;
    private final IManager manager;
    private final IEvictionPolicy<T> evictionPolicy;

    public DurationWindowPolicy(long millis, IManager<T> mgr, IEvictionPolicy<T> policy) {
        this.duration = millis;
        this.manager = mgr;
        this.evictionPolicy = policy;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("duration-trigger-policy-%d").setDaemon(true).build();
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    @Override
    public boolean validate() {
        return this.duration > 0L;
    }

    @Override
    public String whyInvalid() {
        return null;
    }

    @Override
    public void track(Event<T> event) {
        this.checkFailures();
    }

    @Override
    public void reset() {
        this.checkFailures();
    }

    private void checkFailures() {
        if (this.executorFuture != null && this.executorFuture.isDone()) {
            try {
                this.executorFuture.get();
            }
            catch (InterruptedException ex) {
                LOG.severe(String.format("Exception %s", ex.getMessage()));
            }
            catch (ExecutionException ex) {
                LOG.severe(String.format("Exception %s", ex.getMessage()));
            }
        }
    }

    @Override
    public void start() {
        this.executorFuture = this.executor.scheduleAtFixedRate(this.newTriggerTask(), this.duration, this.duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private Runnable newTriggerTask() {
        return new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis() - 1L;
                try {
                    if (DurationWindowPolicy.this.evictionPolicy != null) {
                        DurationWindowPolicy.this.evictionPolicy.setContext(new DefaultEvictionContext(now, null, null, DurationWindowPolicy.this.duration));
                    }
                    DurationWindowPolicy.this.manager.onEvent();
                }
                catch (Throwable th) {
                    LOG.severe(String.format("manager.onEvent failed %s", th.getMessage()));
                    throw th;
                }
            }
        };
    }

    public String toString() {
        return "DurationWindowPolicy{duration=" + this.duration + '}';
    }
}

