/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.util;

import edu.iu.dsc.tws.task.window.api.IWindow;
import edu.iu.dsc.tws.task.window.config.SlidingCountWindow;
import edu.iu.dsc.tws.task.window.config.SlidingDurationWindow;
import edu.iu.dsc.tws.task.window.config.TumblingCountWindow;
import edu.iu.dsc.tws.task.window.config.TumblingDurationWindow;
import edu.iu.dsc.tws.task.window.config.WindowConfig;
import edu.iu.dsc.tws.task.window.constant.WindowBuffer;
import edu.iu.dsc.tws.task.window.exceptions.InvalidWindow;
import java.util.logging.Logger;

public final class WindowUtils {
    private static final Logger LOG = Logger.getLogger(WindowUtils.class.getName());

    private WindowUtils() {
    }

    public static IWindow getWindow(WindowConfig.Count windowCount, WindowConfig.Count slidingCount, WindowConfig.Duration windowDuration, WindowConfig.Duration slidingDuration) throws InvalidWindow {
        IWindow iWindow = null;
        if (windowCount != null && slidingCount != null) {
            iWindow = WindowUtils.checkType(windowCount.value, slidingCount.value, WindowBuffer.Count);
        }
        if (windowDuration != null && slidingDuration != null) {
            LOG.info(String.format("Duration GetWindow", new Object[0]));
            iWindow = WindowUtils.checkType(windowDuration.value, slidingDuration.value, WindowBuffer.Duration);
        }
        return iWindow;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IWindow checkType(long windowLength, long slidingLength, WindowBuffer buffer) throws InvalidWindow {
        void var5_10;
        Object var5_3 = null;
        if (windowLength <= 0L || slidingLength <= 0L || buffer == null) throw new InvalidWindow("Window Length and Sliding Length must be greater than zero");
        if (windowLength == slidingLength) {
            if (buffer == WindowBuffer.Count) {
                LOG.info(String.format("Selecting Tumbling Count Window", new Object[0]));
                TumblingCountWindow tumblingCountWindow = new TumblingCountWindow(windowLength);
            }
            if (buffer != WindowBuffer.Duration) return var5_10;
            LOG.info(String.format("Selecting Tumbling Duration Window", new Object[0]));
            TumblingDurationWindow tumblingDurationWindow = new TumblingDurationWindow(windowLength);
            return var5_10;
        } else {
            if (windowLength <= slidingLength) throw new InvalidWindow("Invalid window, window size > sliding length");
            if (buffer == WindowBuffer.Count) {
                LOG.info(String.format("Selecting Sliding Count Window", new Object[0]));
                SlidingCountWindow slidingCountWindow = new SlidingCountWindow(windowLength, slidingLength);
            }
            if (buffer != WindowBuffer.Duration) return var5_10;
            LOG.info(String.format("Selecting Sliding Duration Window", new Object[0]));
            SlidingDurationWindow slidingDurationWindow = new SlidingDurationWindow(windowLength, slidingLength);
        }
        return var5_10;
    }
}

