/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.cdfw;

import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.task.cdfw.DataFlowGraph;
import edu.iu.dsc.tws.task.cdfw.ICDFWScheduler;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class CDFWScheduler
implements ICDFWScheduler {
    private static final Logger LOG = Logger.getLogger(CDFWScheduler.class.getName());
    private List<JobMasterAPI.WorkerInfo> workerInfoList;
    private Set<Integer> workerList = new LinkedHashSet<Integer>();
    private Map<DataFlowGraph, Set<Integer>> scheduledGraphMap = new LinkedHashMap<DataFlowGraph, Set<Integer>>();

    protected CDFWScheduler(List<JobMasterAPI.WorkerInfo> workerInfoList) {
        this.workerInfoList = workerInfoList;
    }

    @Override
    public Set<Integer> schedule(DataFlowGraph graphJob) {
        Set<Integer> scheduledGraph = this.scheduleGraphs(graphJob);
        return scheduledGraph;
    }

    @Override
    public Map<DataFlowGraph, Set<Integer>> schedule(DataFlowGraph ... dataFlowGraphs) {
        if (dataFlowGraphs.length == 1) {
            this.workerList = this.scheduleGraphs(dataFlowGraphs[0]);
            this.scheduledGraphMap.put(dataFlowGraphs[0], this.workerList);
        } else if (dataFlowGraphs.length > 1) {
            for (DataFlowGraph graph : dataFlowGraphs) {
                this.workerList = this.scheduleGraphs(graph);
                this.scheduledGraphMap.put(graph, this.workerList);
            }
        }
        return this.scheduledGraphMap;
    }

    private Set<Integer> scheduleGraphs(DataFlowGraph graph) {
        if (this.workerInfoList.size() == graph.getWorkers()) {
            for (JobMasterAPI.WorkerInfo workerInfos : this.workerInfoList) {
                this.workerList.add(workerInfos.getWorkerID());
            }
        } else if (this.workerInfoList.size() > graph.getWorkers()) {
            for (JobMasterAPI.WorkerInfo workerInfos : this.workerInfoList) {
                IntStream.range(0, graph.getWorkers()).mapToObj(i -> workerInfos.getWorkerID()).forEachOrdered(this.workerList::add);
                if (this.workerList.size() != graph.getWorkers()) continue;
                break;
            }
        } else {
            throw new Twister2RuntimeException("Insufficient resources to run the dataflow graph");
        }
        return this.workerList;
    }
}

