/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageTypes;
import edu.iu.dsc.tws.api.comms.packing.MessageSchema;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.ComputeConnectionUtils;
import edu.iu.dsc.tws.task.impl.ops.OpConfigValidationFailedException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractOpsConfig<T extends AbstractOpsConfig> {
    private static final Logger LOG = Logger.getLogger(AbstractOpsConfig.class.getName());
    protected String source;
    protected String operationName;
    protected ComputeConnection computeConnection;
    protected String edgeName = "default";
    protected MessageType opDataType = MessageTypes.OBJECT;
    protected Map<String, Object> propertiesMap;
    protected MessageSchema messageSchema = MessageSchema.noSchema();

    protected AbstractOpsConfig(String source, String operationName, ComputeConnection computeConnection) {
        this.source = source;
        this.operationName = operationName;
        this.computeConnection = computeConnection;
        this.propertiesMap = new HashMap<String, Object>();
    }

    public T viaEdge(String edge) {
        this.edgeName = edge;
        return (T)this;
    }

    public T withProperties(Map<String, Object> properties) {
        this.propertiesMap.putAll(properties);
        return (T)this;
    }

    public T withProperty(String propertyName, Object property) {
        this.propertiesMap.put(propertyName, property);
        return (T)this;
    }

    public T withDataType(MessageType dataType) {
        this.opDataType = dataType;
        return (T)this;
    }

    public T withMessageSchema(MessageSchema mc) {
        this.messageSchema = mc;
        return (T)this;
    }

    public String getSource() {
        return this.source;
    }

    public String getEdgeName() {
        return this.edgeName;
    }

    protected MessageType getOpDataType() {
        return this.opDataType;
    }

    abstract void validate();

    protected void runValidation() {
        if (this.source == null) {
            throw new OpConfigValidationFailedException("Parent can't be null");
        }
        this.validate();
    }

    protected static void failValidation(String msg) {
        throw new OpConfigValidationFailedException(msg);
    }

    protected abstract Edge updateEdge(Edge var1);

    public ComputeConnection connect() {
        ComputeConnectionUtils.connectEdge(this.computeConnection, this.source, this.buildEdge());
        return this.computeConnection;
    }

    protected void generateSchema() {
        if (this.opDataType.isPrimitive() && !this.opDataType.isArray() && this.messageSchema == MessageSchema.noSchema()) {
            this.messageSchema = MessageSchema.ofSize((int)this.opDataType.getUnitSizeInBytes());
        }
    }

    Edge buildEdge() {
        this.runValidation();
        Edge edge = new Edge(this.edgeName, this.operationName);
        edge.setDataType(this.opDataType);
        edge.addProperties(this.propertiesMap);
        this.generateSchema();
        edge.setMessageSchema(this.messageSchema);
        return this.updateEdge(edge);
    }
}

