/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.comms.CommunicationContext;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageTypes;
import edu.iu.dsc.tws.api.comms.packing.MessageSchema;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.ComputeConnectionUtils;
import edu.iu.dsc.tws.task.impl.ops.AbstractKeyedOpsConfig;
import edu.iu.dsc.tws.task.impl.ops.OpConfigValidationFailedException;
import java.util.Comparator;

public class JoinConfig
extends AbstractKeyedOpsConfig<JoinConfig> {
    private Comparator keyCompartor;
    private String rightSource;
    private String rightEdgeName;
    private MessageType rightOpDataType = MessageTypes.OBJECT;
    private String group;
    private MessageSchema rightMessageSchema = MessageSchema.noSchema();

    public JoinConfig(String leftParent, String rightParent, ComputeConnection computeConnection, CommunicationContext.JoinType joinType, CommunicationContext.JoinAlgorithm joinAlgorithm) {
        super(leftParent, "join", computeConnection);
        this.rightSource = rightParent;
        this.withProperty("use-disk", false);
        this.withProperty("join-type", joinType);
        this.withProperty("join-algorithm", joinAlgorithm);
    }

    @Override
    public JoinConfig useDisk(boolean useDisk) {
        return (JoinConfig)this.withProperty("use-disk", useDisk);
    }

    public <T> JoinConfig withComparator(Comparator<T> keyComparator) {
        this.keyCompartor = keyComparator;
        return (JoinConfig)this.withProperty("key-comparator", keyComparator);
    }

    public JoinConfig viaLeftEdge(String edge) {
        this.edgeName = edge;
        return this;
    }

    public JoinConfig viaRightEdge(String edge) {
        this.rightEdgeName = edge;
        return this;
    }

    public JoinConfig withRightDataType(MessageType dataType) {
        this.rightOpDataType = dataType;
        return this;
    }

    public JoinConfig withLeftDataType(MessageType dataType) {
        this.opDataType = dataType;
        return this;
    }

    @Override
    public JoinConfig withMessageSchema(MessageSchema messageSchema) {
        super.withMessageSchema(messageSchema);
        this.rightMessageSchema = messageSchema;
        return this;
    }

    public JoinConfig withLeftMessageSchema(MessageSchema messageSchema) {
        this.messageSchema = messageSchema;
        return this;
    }

    public JoinConfig withRightMessageSchema(MessageSchema messageSchema) {
        this.rightMessageSchema = messageSchema;
        return this;
    }

    public JoinConfig withTargetEdge(String g) {
        this.group = g;
        return this;
    }

    @Override
    void validate() {
        if (this.keyCompartor == null) {
            JoinConfig.failValidation("Join operation needs a key comparator.");
        }
        if (this.rightEdgeName == null) {
            JoinConfig.failValidation("Right edge should have a name");
        }
        if (this.rightSource == null) {
            throw new OpConfigValidationFailedException("Parent can't be null");
        }
    }

    @Override
    protected void generateSchema() {
        super.generateSchema();
        if (this.rightOpDataType.isPrimitive() && this.opKeyType.isPrimitive() && !this.rightOpDataType.isArray() && !this.opKeyType.isArray() && this.rightMessageSchema == MessageSchema.noSchema()) {
            this.rightMessageSchema = MessageSchema.ofSize((int)(this.rightOpDataType.getUnitSizeInBytes() + this.opKeyType.getUnitSizeInBytes()), (int)this.opKeyType.getUnitSizeInBytes());
        }
    }

    @Override
    public ComputeConnection connect() {
        Edge leftEdge = this.buildEdge();
        leftEdge.setEdgeIndex(0);
        leftEdge.setNumberOfEdges(2);
        Edge rightEdge = this.buildRightEdge();
        rightEdge.setEdgeIndex(1);
        rightEdge.setNumberOfEdges(2);
        rightEdge.setMessageSchema(this.rightMessageSchema);
        if (this.group == null) {
            this.group = this.edgeName + "-" + this.rightEdgeName + "-" + this.source + "-" + this.rightSource;
        }
        leftEdge.setTargetEdge(this.group);
        rightEdge.setTargetEdge(this.group);
        ComputeConnectionUtils.connectEdge(this.computeConnection, this.source, leftEdge);
        ComputeConnectionUtils.connectEdge(this.computeConnection, this.rightSource, rightEdge);
        return this.computeConnection;
    }

    Edge buildRightEdge() {
        Edge edge = new Edge(this.rightEdgeName, this.operationName);
        edge.setDataType(this.rightOpDataType);
        edge.addProperties(this.propertiesMap);
        edge.setMessageSchema(this.rightMessageSchema);
        this.updateEdge(edge);
        edge.setKeyed(true);
        edge.setKeyType(this.opKeyType);
        edge.setPartitioner(this.tPartitioner);
        return edge;
    }

    @Override
    protected Edge updateEdge(Edge newEdge) {
        return newEdge;
    }
}

