/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.collectives;

import edu.iu.dsc.tws.api.compute.IMessage;
import edu.iu.dsc.tws.task.window.api.IWindowMessage;
import edu.iu.dsc.tws.task.window.core.BaseWindowedSink;
import edu.iu.dsc.tws.task.window.function.ReduceWindowedFunction;

public abstract class ReduceWindow<T>
extends BaseWindowedSink<T> {
    private ReduceWindowedFunction<T> reduceWindowedFunction;

    public abstract boolean reduce(T var1);

    public abstract boolean reduceLateMessage(T var1);

    public ReduceWindow(ReduceWindowedFunction<T> reduceWindowedFunction) {
        this.reduceWindowedFunction = reduceWindowedFunction;
    }

    @Override
    public boolean execute(IWindowMessage<T> windowMessage) {
        if (windowMessage != null) {
            Object current = null;
            for (IMessage<T> msg : windowMessage.getWindow()) {
                Object value = msg.getContent();
                if (current == null) {
                    current = value;
                    continue;
                }
                current = this.reduceWindowedFunction.onMessage(current, value);
            }
            this.reduce(current);
        }
        return true;
    }

    @Override
    public boolean getLateMessages(IMessage<T> lateMessages) {
        Object lateMsg = lateMessages.getContent();
        if (lateMsg != null) {
            return this.reduceLateMessage(this.reduceWindowedFunction.reduceLateMessage(lateMsg));
        }
        return false;
    }

    @Override
    public boolean getExpire(IWindowMessage<T> expiredMessages) {
        return false;
    }
}

