/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.trigger;

import edu.iu.dsc.tws.task.window.config.WindowConfig;
import edu.iu.dsc.tws.task.window.constant.WindowType;
import edu.iu.dsc.tws.task.window.policy.trigger.WindowingPolicy;

public class WindowingTumblingPolicy
extends WindowingPolicy {
    private static final String RULE = "WindowType TUMBLING && (Window Count > 0 || Window Duration NOT NULL)";
    private WindowType windowType = WindowType.TUMBLING;
    private WindowConfig.Count count;
    private WindowConfig.Duration duration;

    public WindowingTumblingPolicy(WindowConfig.Count cnt) {
        super(WindowType.TUMBLING, cnt);
        this.count = cnt;
    }

    public WindowingTumblingPolicy(WindowConfig.Duration dtn) {
        super(WindowType.TUMBLING, dtn);
        this.duration = dtn;
    }

    @Override
    public WindowType getWindowType() {
        return this.windowType;
    }

    public void setWindowType(WindowType winType) {
        this.windowType = winType;
    }

    @Override
    public WindowConfig.Count getCount() {
        return this.count;
    }

    public void setCount(WindowConfig.Count cnt) {
        this.count = cnt;
    }

    @Override
    public WindowConfig.Duration getDuration() {
        return this.duration;
    }

    public void setDuration(WindowConfig.Duration dtn) {
        this.duration = dtn;
    }

    @Override
    public boolean validate() {
        return this.windowType == WindowType.TUMBLING && (this.count.value > 0L || this.duration != null);
    }

    @Override
    public String whyInvalid() {
        return String.format("Rule : %s, Current Config :WindowType : %s, Window Count : %d, Window Duration : %s", new Object[]{RULE, this.windowType, this.count.value, this.duration});
    }
}

