/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.trigger.count;

import edu.iu.dsc.tws.task.window.api.DefaultEvictionContext;
import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.api.IEvictionPolicy;
import edu.iu.dsc.tws.task.window.manage.IManager;
import edu.iu.dsc.tws.task.window.policy.trigger.IWindowingPolicy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class CountWindowPolicy<T>
implements IWindowingPolicy<T> {
    private static final Logger LOG = Logger.getLogger(CountWindowPolicy.class.getName());
    private final long count;
    private final AtomicInteger currentCount;
    private final IManager manager;
    private final IEvictionPolicy<T> evictionPolicy;
    private boolean started;

    public CountWindowPolicy(long count, IManager manager, IEvictionPolicy<T> evictionPolicy) {
        this.count = count;
        this.manager = manager;
        this.evictionPolicy = evictionPolicy;
        this.currentCount = new AtomicInteger();
        this.started = false;
    }

    @Override
    public boolean validate() {
        return this.count > 0L;
    }

    @Override
    public String whyInvalid() {
        return null;
    }

    @Override
    public void track(Event<T> event) {
        if (this.started && !event.isWatermark() && (long)this.currentCount.incrementAndGet() >= this.count) {
            this.evictionPolicy.setContext(new DefaultEvictionContext(System.currentTimeMillis()));
            this.manager.onEvent();
        }
    }

    @Override
    public void reset() {
        this.currentCount.set(0);
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void shutdown() {
    }

    public String toString() {
        return "CountWindowPolicy{count=" + this.count + ", currentCount=" + this.currentCount + ", manager=" + this.manager + ", evictionPolicy=" + this.evictionPolicy + ", started=" + this.started + '}';
    }
}

