/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.trigger.count;

import edu.iu.dsc.tws.task.window.api.DefaultEvictionContext;
import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.api.IEvictionPolicy;
import edu.iu.dsc.tws.task.window.manage.IManager;
import edu.iu.dsc.tws.task.window.manage.WindowManager;
import edu.iu.dsc.tws.task.window.policy.trigger.count.CountWindowPolicy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class WatermarkCountWindowPolicy<T>
extends CountWindowPolicy<T> {
    private final long count;
    private final AtomicInteger currentCount;
    private final IManager manager;
    private final WindowManager<T> windowManager;
    private final IEvictionPolicy<T> evictionPolicy;
    private boolean started;
    private long lastProcessedTimestamp = 0L;

    public WatermarkCountWindowPolicy(long count, IManager manager, IEvictionPolicy<T> evictionPolicy, WindowManager<T> winManager) {
        super(count, manager, evictionPolicy);
        this.count = count;
        this.manager = manager;
        this.windowManager = winManager;
        this.evictionPolicy = evictionPolicy;
        this.currentCount = new AtomicInteger();
        this.started = false;
    }

    @Override
    public boolean validate() {
        return this.count > 0L;
    }

    @Override
    public String whyInvalid() {
        return null;
    }

    @Override
    public void track(Event<T> event) {
        if (this.started && event.isWatermark()) {
            this.onWatermarkEvent(event);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void shutdown() {
    }

    private void onWatermarkEvent(Event<T> watermarkEvent) {
        long watermarkTimestamp = watermarkEvent.getTimeStamp();
        List<Long> eventTimestamps = this.windowManager.getSlidingCountTimestamps(this.lastProcessedTimestamp, watermarkTimestamp, this.count);
        for (long t : eventTimestamps) {
            this.evictionPolicy.setContext(new DefaultEvictionContext(t, null, this.count));
            this.manager.onEvent();
            this.lastProcessedTimestamp = t;
        }
    }

    @Override
    public String toString() {
        return "WatermarkCountTriggerPolicy{count=" + this.count + ", currentCount=" + this.currentCount + ", manager=" + this.manager + ", windowManager=" + this.windowManager + ", evictionPolicy=" + this.evictionPolicy + ", started=" + this.started + ", lastProcessedTimestamp=" + this.lastProcessedTimestamp + '}';
    }
}

