/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.taskscheduler;

import edu.iu.dsc.tws.api.compute.exceptions.TaskSchedulerException;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.schedule.ITaskScheduler;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskSchedulePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerPlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerSchedulePlan;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.tsched.spi.common.TaskSchedulerContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TaskScheduler
implements ITaskScheduler {
    private static final Logger LOG = Logger.getLogger(TaskScheduler.class.getName());
    private Config config;
    private ComputeGraph computeGraph;
    private ComputeGraph[] computeGraphs;
    private WorkerPlan workerPlan;
    private String schedulingType;
    private int workerId;

    public void initialize(Config cfg) {
        this.config = cfg;
    }

    public void initialize(Config cfg, int workerid) {
        this.config = cfg;
        this.workerId = workerid;
    }

    public TaskSchedulePlan schedule(ComputeGraph graph, WorkerPlan plan) {
        this.computeGraph = graph;
        this.workerPlan = plan;
        TaskSchedulePlan taskSchedulePlan = null;
        if ("STREAMING".equals(graph.getOperationMode().toString())) {
            taskSchedulePlan = this.scheduleStreamingTask();
        } else if ("BATCH".equals(graph.getOperationMode().toString())) {
            taskSchedulePlan = this.scheduleBatchTask();
        }
        return taskSchedulePlan;
    }

    public Map<String, TaskSchedulePlan> schedule(WorkerPlan plan, ComputeGraph ... graphs) {
        this.computeGraphs = graphs;
        this.workerPlan = plan;
        Map<String, TaskSchedulePlan> schedulePlanMap = this.scheduleBatchGraphs();
        return schedulePlanMap;
    }

    private TaskSchedulePlan scheduleStreamingTask() {
        this.schedulingType = this.config.getStringValue("SchedulingMode") != null ? this.config.getStringValue("SchedulingMode") : TaskSchedulerContext.streamingTaskSchedulingMode(this.config);
        if (this.workerId == 0) {
            LOG.fine("Task Scheduling Type:" + this.schedulingType + "(streaming task)");
        }
        return this.generateTaskSchedulePlan(TaskSchedulerContext.streamingTaskSchedulingClass(this.config));
    }

    private TaskSchedulePlan scheduleBatchTask() {
        this.schedulingType = this.config.getStringValue("SchedulingMode") != null ? this.config.getStringValue("SchedulingMode") : TaskSchedulerContext.batchTaskSchedulingMode(this.config);
        if (this.workerId == 0) {
            LOG.fine("Task Scheduling Type:" + this.schedulingType + "(batch task)");
        }
        return this.generateTaskSchedulePlan(TaskSchedulerContext.batchTaskSchedulingClass(this.config));
    }

    private Map<String, TaskSchedulePlan> scheduleBatchGraphs() {
        this.schedulingType = this.config.getStringValue("SchedulingMode") != null ? this.config.getStringValue("SchedulingMode") : TaskSchedulerContext.batchTaskSchedulingMode(this.config);
        if (this.workerId == 0) {
            LOG.fine("Task Scheduling Type:" + this.schedulingType + "(batch task)");
        }
        return this.generateTaskSchedulePlans(TaskSchedulerContext.batchTaskSchedulingClass(this.config));
    }

    private TaskSchedulePlan generateTaskSchedulePlan(String className) {
        TaskSchedulePlan taskSchedulePlan;
        try {
            Class<?> taskSchedulerClass = this.getClass().getClassLoader().loadClass(className);
            Object newInstance = taskSchedulerClass.newInstance();
            Method method = taskSchedulerClass.getMethod("initialize", Config.class);
            method.invoke(newInstance, this.config);
            method = taskSchedulerClass.getMethod("schedule", ComputeGraph.class, WorkerPlan.class);
            taskSchedulePlan = (TaskSchedulePlan)method.invoke(newInstance, this.computeGraph, this.workerPlan);
        }
        catch (TaskSchedulerException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Twister2RuntimeException(e);
        }
        if (taskSchedulePlan != null) {
            Map containersMap = taskSchedulePlan.getContainersMap();
            for (Map.Entry entry : containersMap.entrySet()) {
                Integer integer = (Integer)entry.getKey();
                WorkerSchedulePlan workerSchedulePlan = (WorkerSchedulePlan)entry.getValue();
                Set containerPlanTaskInstances = workerSchedulePlan.getTaskInstances();
                LOG.fine("Task Details for Container Id:" + integer);
                for (TaskInstancePlan ip : containerPlanTaskInstances) {
                    LOG.fine("Task Id:" + ip.getTaskId() + "\tTask Index" + ip.getTaskIndex() + "\tTask Name:" + ip.getTaskName());
                }
            }
        }
        return taskSchedulePlan;
    }

    private Map<String, TaskSchedulePlan> generateTaskSchedulePlans(String className) {
        Map taskSchedulePlanMap;
        try {
            Class<?> taskSchedulerClass = this.getClass().getClassLoader().loadClass(className);
            Object newInstance = taskSchedulerClass.newInstance();
            Method method = taskSchedulerClass.getMethod("initialize", Config.class);
            method.invoke(newInstance, this.config);
            method = taskSchedulerClass.getMethod("schedule", WorkerPlan.class, ComputeGraph[].class);
            taskSchedulePlanMap = (Map)method.invoke(newInstance, this.workerPlan, this.computeGraphs);
        }
        catch (TaskSchedulerException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Twister2RuntimeException(e);
        }
        return taskSchedulePlanMap;
    }
}

