/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.batch.roundrobin;

import edu.iu.dsc.tws.api.compute.exceptions.TaskSchedulerException;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.api.compute.schedule.ITaskScheduler;
import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstanceId;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskSchedulePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.Worker;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerPlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerSchedulePlan;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.tsched.spi.common.TaskSchedulerContext;
import edu.iu.dsc.tws.tsched.spi.taskschedule.TaskInstanceMapCalculation;
import edu.iu.dsc.tws.tsched.utils.TaskAttributes;
import edu.iu.dsc.tws.tsched.utils.TaskVertexParser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class RoundRobinBatchTaskScheduler
implements ITaskScheduler {
    private static final Logger LOG = Logger.getLogger(RoundRobinBatchTaskScheduler.class.getName());
    private int gTaskId = 0;
    private Double instanceRAM;
    private Double instanceDisk;
    private Double instanceCPU;
    private Config config;
    private int workerId;
    private Map<Integer, List<TaskInstanceId>> roundRobinAllocation;
    private TaskAttributes taskAttributes;

    public void initialize(Config cfg) {
        this.config = cfg;
        this.instanceRAM = TaskSchedulerContext.taskInstanceRam(this.config);
        this.instanceDisk = TaskSchedulerContext.taskInstanceDisk(this.config);
        this.instanceCPU = TaskSchedulerContext.taskInstanceCpu(this.config);
        this.roundRobinAllocation = new HashMap<Integer, List<TaskInstanceId>>();
        this.taskAttributes = new TaskAttributes();
    }

    public void initialize(Config cfg, int workerid) {
        this.initialize(cfg);
        this.workerId = workerid;
    }

    public TaskSchedulePlan schedule(ComputeGraph computeGraph, WorkerPlan workerPlan) {
        LinkedHashMap<Integer, WorkerSchedulePlan> containerPlans = new LinkedHashMap<Integer, WorkerSchedulePlan>();
        for (int i = 0; i < workerPlan.getNumberOfWorkers(); ++i) {
            this.roundRobinAllocation.put(i, new ArrayList());
        }
        LinkedHashSet<Vertex> taskVertexSet = new LinkedHashSet<Vertex>(computeGraph.getTaskVertexSet());
        TaskVertexParser taskGraphParser = new TaskVertexParser();
        List<Set<Vertex>> taskVertexList = taskGraphParser.parseVertexSet(computeGraph);
        for (Set<Vertex> vertexSet : taskVertexList) {
            Map<Integer, List<TaskInstanceId>> containerInstanceMap;
            if (vertexSet.size() > 1) {
                containerInstanceMap = this.roundRobinBatchSchedulingAlgorithm(computeGraph, vertexSet);
            } else {
                Vertex vertex = vertexSet.iterator().next();
                containerInstanceMap = this.roundRobinBatchSchedulingAlgorithm(computeGraph, vertex);
            }
            TaskInstanceMapCalculation instanceMapCalculation = new TaskInstanceMapCalculation(this.instanceRAM, this.instanceCPU, this.instanceDisk);
            Map<Integer, Map<TaskInstanceId, Double>> instancesRamMap = instanceMapCalculation.getInstancesRamMapInContainer(containerInstanceMap, taskVertexSet);
            Map<Integer, Map<TaskInstanceId, Double>> instancesDiskMap = instanceMapCalculation.getInstancesDiskMapInContainer(containerInstanceMap, taskVertexSet);
            Map<Integer, Map<TaskInstanceId, Double>> instancesCPUMap = instanceMapCalculation.getInstancesCPUMapInContainer(containerInstanceMap, taskVertexSet);
            for (int containerId : containerInstanceMap.keySet()) {
                WorkerSchedulePlan taskWorkerSchedulePlan;
                double containerRAMValue = TaskSchedulerContext.containerRamPadding(this.config);
                double containerDiskValue = TaskSchedulerContext.containerDiskPadding(this.config);
                double containerCpuValue = TaskSchedulerContext.containerCpuPadding(this.config);
                List<TaskInstanceId> taskTaskInstanceIds = containerInstanceMap.get(containerId);
                HashMap<TaskInstanceId, TaskInstancePlan> taskInstancePlanMap = new HashMap<TaskInstanceId, TaskInstancePlan>();
                for (TaskInstanceId id : taskTaskInstanceIds) {
                    double instanceRAMValue = instancesRamMap.get(containerId).get(id);
                    double instanceDiskValue = instancesDiskMap.get(containerId).get(id);
                    double instanceCPUValue = instancesCPUMap.get(containerId).get(id);
                    Resource instanceResource = new Resource(Double.valueOf(instanceRAMValue), Double.valueOf(instanceDiskValue), Double.valueOf(instanceCPUValue));
                    taskInstancePlanMap.put(id, new TaskInstancePlan(id.getTaskName(), id.getTaskId(), id.getTaskIndex(), instanceResource));
                    containerRAMValue += instanceRAMValue;
                    containerDiskValue += instanceDiskValue;
                    containerCpuValue += instanceDiskValue;
                }
                Worker worker = workerPlan.getWorker(containerId);
                Resource containerResource = worker != null && worker.getCpu() > 0 && worker.getDisk() > 0 && worker.getRam() > 0 ? new Resource(Double.valueOf(worker.getRam()), Double.valueOf(worker.getDisk()), Double.valueOf(worker.getCpu())) : new Resource(Double.valueOf(containerRAMValue), Double.valueOf(containerDiskValue), Double.valueOf(containerCpuValue));
                if (containerPlans.containsKey(containerId)) {
                    taskWorkerSchedulePlan = (WorkerSchedulePlan)containerPlans.get(containerId);
                    taskWorkerSchedulePlan.getTaskInstances().addAll(taskInstancePlanMap.values());
                    continue;
                }
                taskWorkerSchedulePlan = new WorkerSchedulePlan(containerId, new HashSet(taskInstancePlanMap.values()), containerResource);
                containerPlans.put(containerId, taskWorkerSchedulePlan);
            }
        }
        return new TaskSchedulePlan(0, new HashSet(containerPlans.values()));
    }

    private Map<Integer, List<TaskInstanceId>> roundRobinBatchSchedulingAlgorithm(ComputeGraph graph, Vertex vertex) throws TaskSchedulerException {
        if (!graph.getGraphConstraints().isEmpty()) {
            Map<String, Integer> parallelTaskMap = !graph.getNodeConstraints().isEmpty() ? this.taskAttributes.getParallelTaskMap(vertex, (Map<String, Map<String, String>>)graph.getNodeConstraints()) : this.taskAttributes.getParallelTaskMap(vertex);
            this.roundRobinAllocation = this.attributeBasedAllocation(parallelTaskMap, graph);
        } else {
            Map<String, Integer> parallelTaskMap = this.taskAttributes.getParallelTaskMap(vertex);
            this.roundRobinAllocation = this.nonAttributeBasedAllocation(parallelTaskMap);
        }
        return this.roundRobinAllocation;
    }

    private Map<Integer, List<TaskInstanceId>> roundRobinBatchSchedulingAlgorithm(ComputeGraph graph, Set<Vertex> vertexSet) throws TaskSchedulerException {
        TreeSet<Vertex> orderedTaskSet = new TreeSet<Vertex>(new VertexComparator());
        orderedTaskSet.addAll(vertexSet);
        if (!graph.getGraphConstraints().isEmpty()) {
            Map<String, Integer> parallelTaskMap = !graph.getNodeConstraints().isEmpty() ? this.taskAttributes.getParallelTaskMap(vertexSet, (Map<String, Map<String, String>>)graph.getNodeConstraints()) : this.taskAttributes.getParallelTaskMap(vertexSet);
            this.roundRobinAllocation = this.attributeBasedAllocation(parallelTaskMap, graph);
        } else {
            Map<String, Integer> parallelTaskMap = this.taskAttributes.getParallelTaskMap(vertexSet);
            this.roundRobinAllocation = this.nonAttributeBasedAllocation(parallelTaskMap);
        }
        return this.roundRobinAllocation;
    }

    private Map<Integer, List<TaskInstanceId>> attributeBasedAllocation(Map<String, Integer> parallelTaskMap, ComputeGraph graph) {
        int containerIndex = 0;
        int instancesPerContainer = this.taskAttributes.getInstancesPerWorker(graph.getGraphConstraints());
        for (Map.Entry<String, Integer> e : parallelTaskMap.entrySet()) {
            String task = e.getKey();
            int taskParallelism = e.getValue();
            int numberOfInstances = instancesPerContainer < taskParallelism ? taskParallelism : instancesPerContainer;
            for (int taskIndex = 0; taskIndex < numberOfInstances; ++taskIndex) {
                this.roundRobinAllocation.get(containerIndex).add(new TaskInstanceId(task, this.gTaskId, taskIndex));
                if (++containerIndex < this.roundRobinAllocation.size()) continue;
                containerIndex = 0;
            }
            ++this.gTaskId;
        }
        return this.roundRobinAllocation;
    }

    private Map<Integer, List<TaskInstanceId>> nonAttributeBasedAllocation(Map<String, Integer> parallelTaskMap) {
        int containerIndex = 0;
        for (Map.Entry<String, Integer> e : parallelTaskMap.entrySet()) {
            String task = e.getKey();
            int numberOfInstances = e.getValue();
            for (int taskIndex = 0; taskIndex < numberOfInstances; ++taskIndex) {
                this.roundRobinAllocation.get(containerIndex).add(new TaskInstanceId(task, this.gTaskId, taskIndex));
                if (++containerIndex < this.roundRobinAllocation.size()) continue;
                containerIndex = 0;
            }
            ++this.gTaskId;
        }
        return this.roundRobinAllocation;
    }

    private static class VertexComparator
    implements Comparator<Vertex> {
        private VertexComparator() {
        }

        @Override
        public int compare(Vertex o1, Vertex o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

