/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.spi.taskschedule;

import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstanceId;
import edu.iu.dsc.tws.tsched.utils.TaskAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TaskInstanceMapCalculation {
    private static final Logger LOG = Logger.getLogger(TaskInstanceMapCalculation.class.getName());
    private static final double DEFAULT_DISK_PADDING_PER_CONTAINER = 12.0;
    private static final double DEFAULT_RAM_PADDING_PER_CONTAINER = 2.0;
    private static final double NOT_SPECIFIED_NUMBER_VALUE = -1.0;
    private static final double DEFAULT_CPU_PADDING_PER_CONTAINER = 1.0;
    private final Double instanceRAM;
    private final Double instanceDisk;
    private final Double instanceCPU;
    private TaskAttributes taskAttributes;

    public TaskInstanceMapCalculation(Double instanceRam, Double instanceDisk, Double instanceCPU) {
        this.instanceRAM = instanceRam;
        this.instanceDisk = instanceDisk;
        this.instanceCPU = instanceCPU;
        this.taskAttributes = new TaskAttributes();
    }

    private static double getContainerCpuValue(Map<Integer, List<TaskInstanceId>> instancesAllocation) {
        String cpuHint = "0.2";
        return Double.parseDouble(cpuHint);
    }

    private static Double getContainerDiskValue(Map<Integer, List<TaskInstanceId>> instancesAllocation) {
        String containerDiskValue = "1000.0";
        return Double.parseDouble(containerDiskValue);
    }

    private static Double getContainerRamValue(Map<Integer, List<TaskInstanceId>> instancesAllocation) {
        String containerRamValue = "1000.0";
        return Double.parseDouble(containerRamValue);
    }

    public Map<Integer, Map<TaskInstanceId, Double>> getInstancesRamMapInContainer(Map<Integer, List<TaskInstanceId>> containerInstanceAllocationMap, Set<Vertex> taskVertexSet) {
        Map<String, Double> ramMap = this.taskAttributes.getTaskRamMap(taskVertexSet);
        HashMap<Integer, Map<TaskInstanceId, Double>> instancesRamContainerMap = new HashMap<Integer, Map<TaskInstanceId, Double>>();
        for (int containerId : containerInstanceAllocationMap.keySet()) {
            Double usedRamValue = 0.0;
            List<TaskInstanceId> taskInstanceIds = containerInstanceAllocationMap.get(containerId);
            HashMap<TaskInstanceId, Double> containerRam = new HashMap<TaskInstanceId, Double>();
            instancesRamContainerMap.put(containerId, containerRam);
            ArrayList<TaskInstanceId> instancesToBeCalculated = new ArrayList<TaskInstanceId>();
            for (TaskInstanceId taskInstanceId : taskInstanceIds) {
                String taskName = taskInstanceId.getTaskName();
                if (ramMap.containsKey(taskName)) {
                    Double ramValue = ramMap.get(taskName);
                    containerRam.put(taskInstanceId, ramValue);
                    usedRamValue = usedRamValue + ramValue;
                    continue;
                }
                instancesToBeCalculated.add(taskInstanceId);
            }
            Double containerRamValue = TaskInstanceMapCalculation.getContainerRamValue(containerInstanceAllocationMap);
            int instancesAllocationSize = instancesToBeCalculated.size();
            if (instancesAllocationSize == 0) continue;
            Double instanceRequiredRam = this.instanceRAM;
            if (!containerRamValue.equals(-1.0)) {
                double remainingRam = containerRamValue - 2.0 - usedRamValue;
                instanceRequiredRam = remainingRam / (double)instancesAllocationSize;
            }
            for (TaskInstanceId taskInstanceId : instancesToBeCalculated) {
                containerRam.put(taskInstanceId, instanceRequiredRam);
            }
            LOG.fine("Instances Required Ram:\t" + instanceRequiredRam + "\n");
        }
        return instancesRamContainerMap;
    }

    public Map<Integer, Map<TaskInstanceId, Double>> getInstancesDiskMapInContainer(Map<Integer, List<TaskInstanceId>> containerInstanceAllocationMap, Set<Vertex> taskVertexSet) {
        Map<String, Double> diskMap = this.taskAttributes.getTaskDiskMap(taskVertexSet);
        HashMap<Integer, Map<TaskInstanceId, Double>> instancesDiskContainerMap = new HashMap<Integer, Map<TaskInstanceId, Double>>();
        for (int containerId : containerInstanceAllocationMap.keySet()) {
            Double usedDiskValue = 0.0;
            List<TaskInstanceId> taskInstanceIds = containerInstanceAllocationMap.get(containerId);
            HashMap<TaskInstanceId, Double> containerDisk = new HashMap<TaskInstanceId, Double>();
            instancesDiskContainerMap.put(containerId, containerDisk);
            ArrayList<TaskInstanceId> instancesToBeCalculated = new ArrayList<TaskInstanceId>();
            for (TaskInstanceId taskInstanceId : taskInstanceIds) {
                String taskName = taskInstanceId.getTaskName();
                if (diskMap.containsKey(taskName)) {
                    Double diskValue = diskMap.get(taskName);
                    containerDisk.put(taskInstanceId, diskValue);
                    usedDiskValue = usedDiskValue + diskValue;
                    continue;
                }
                instancesToBeCalculated.add(taskInstanceId);
            }
            Double containerDiskValue = TaskInstanceMapCalculation.getContainerDiskValue(containerInstanceAllocationMap);
            int instancesAllocationSize = instancesToBeCalculated.size();
            if (instancesAllocationSize == 0) continue;
            double instanceRequiredDisk = 0.0;
            if (!containerDiskValue.equals(-1.0)) {
                double remainingDisk = containerDiskValue - 12.0 - usedDiskValue;
                instanceRequiredDisk = remainingDisk / (double)instancesAllocationSize;
            }
            for (TaskInstanceId taskInstanceId : instancesToBeCalculated) {
                containerDisk.put(taskInstanceId, instanceRequiredDisk);
            }
            LOG.fine("Instances Required Disk:\t" + instanceRequiredDisk);
        }
        return instancesDiskContainerMap;
    }

    public Map<Integer, Map<TaskInstanceId, Double>> getInstancesCPUMapInContainer(Map<Integer, List<TaskInstanceId>> containerInstanceAllocationMap, Set<Vertex> taskVertexSet) {
        Map<String, Double> taskCpuMap = this.taskAttributes.getTaskCPUMap(taskVertexSet);
        HashMap<Integer, Map<TaskInstanceId, Double>> instancesCpuContainerMap = new HashMap<Integer, Map<TaskInstanceId, Double>>();
        for (int containerId : containerInstanceAllocationMap.keySet()) {
            Double usedCPUValue = 0.0;
            List<TaskInstanceId> taskInstanceIds = containerInstanceAllocationMap.get(containerId);
            HashMap<TaskInstanceId, Double> containerCPUMap = new HashMap<TaskInstanceId, Double>();
            instancesCpuContainerMap.put(containerId, containerCPUMap);
            ArrayList<TaskInstanceId> instancesToBeCalculated = new ArrayList<TaskInstanceId>();
            for (TaskInstanceId taskInstanceId : taskInstanceIds) {
                String taskName = taskInstanceId.getTaskName();
                if (taskCpuMap.containsKey(taskName)) {
                    Double taskCpuValue = taskCpuMap.get(taskName);
                    containerCPUMap.put(taskInstanceId, taskCpuValue);
                    usedCPUValue = usedCPUValue + taskCpuValue;
                    continue;
                }
                instancesToBeCalculated.add(taskInstanceId);
            }
            Double containerCpuValue = TaskInstanceMapCalculation.getContainerCpuValue(containerInstanceAllocationMap);
            int instancesAllocationSize = instancesToBeCalculated.size();
            if (instancesAllocationSize == 0) continue;
            Double instanceRequiredCpu = 0.0;
            if (!containerCpuValue.equals(-1.0)) {
                double remainingCpu = containerCpuValue - 1.0 - usedCPUValue;
                instanceRequiredCpu = remainingCpu / (double)instancesAllocationSize;
            }
            for (TaskInstanceId taskInstanceId : instancesToBeCalculated) {
                containerCPUMap.put(taskInstanceId, instanceRequiredCpu);
            }
            LOG.fine("Instances Required CPU:\t" + instanceRequiredCpu);
        }
        return instancesCpuContainerMap;
    }
}

