/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.tsched.streaming.firstfit;

import edu.iu.dsc.tws.api.compute.exceptions.TaskSchedulerException;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.api.compute.schedule.ITaskScheduler;
import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskSchedulePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerPlan;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.tsched.builder.ContainerIdScorer;
import edu.iu.dsc.tws.tsched.builder.TaskSchedulePlanBuilder;
import edu.iu.dsc.tws.tsched.spi.common.TaskSchedulerContext;
import edu.iu.dsc.tws.tsched.utils.RequiredRam;
import edu.iu.dsc.tws.tsched.utils.TaskAttributes;
import edu.iu.dsc.tws.tsched.utils.TaskScheduleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class FirstFitStreamingTaskScheduler
implements ITaskScheduler {
    private static final Logger LOG = Logger.getLogger(FirstFitStreamingTaskScheduler.class.getName());
    private Resource defaultResourceValue;
    private Resource maxContainerResourceValue;
    private int paddingPercentage;
    private int numContainers;
    private Config config;
    private Set<Vertex> taskVertexSet = new HashSet<Vertex>();
    private TaskAttributes taskAttributes = new TaskAttributes();

    public void initialize(Config cfg) {
        this.config = cfg;
        double instanceRAM = TaskSchedulerContext.taskInstanceRam(this.config);
        double instanceDisk = TaskSchedulerContext.taskInstanceDisk(this.config);
        double instanceCPU = TaskSchedulerContext.taskInstanceCpu(this.config);
        this.paddingPercentage = TaskSchedulerContext.containerPaddingPercentage(this.config);
        this.defaultResourceValue = new Resource(Double.valueOf(instanceRAM), Double.valueOf(instanceDisk), Double.valueOf(instanceCPU));
        int defaultNoOfTaskInstances = TaskSchedulerContext.defaultTaskInstancesPerContainer(this.config);
        instanceRAM = this.defaultResourceValue.getRam() * (double)defaultNoOfTaskInstances;
        instanceDisk = this.defaultResourceValue.getDisk() * (double)defaultNoOfTaskInstances;
        instanceCPU = this.defaultResourceValue.getCpu() * (double)defaultNoOfTaskInstances;
        this.maxContainerResourceValue = new Resource(Double.valueOf(Math.round(TaskScheduleUtils.increaseBy(instanceRAM, this.paddingPercentage))), Double.valueOf(Math.round(TaskScheduleUtils.increaseBy(instanceDisk, this.paddingPercentage))), Double.valueOf(Math.round(TaskScheduleUtils.increaseBy(instanceCPU, this.paddingPercentage))));
        LOG.fine("Instance default values:RamValue:" + instanceRAM + "\tDiskValue:" + instanceDisk + "\tCPUValue:" + instanceCPU);
        LOG.fine("Container default values:RamValue:" + this.maxContainerResourceValue.getRam() + "\tDiskValue:" + this.maxContainerResourceValue.getDisk() + "\tCPUValue:" + this.maxContainerResourceValue.getCpu());
    }

    public void initialize(Config cfg, int workerId) {
    }

    private TaskSchedulePlanBuilder newTaskSchedulingPlanBuilder(TaskSchedulePlan previousTaskPlan) {
        return new TaskSchedulePlanBuilder(1, previousTaskPlan).setContainerMaximumResourceValue(this.maxContainerResourceValue).setInstanceDefaultResourceValue(this.defaultResourceValue).setRequestedContainerPadding(this.paddingPercentage).setTaskRamMap(this.taskAttributes.getTaskRamMap(this.taskVertexSet)).setTaskDiskMap(this.taskAttributes.getTaskDiskMap(this.taskVertexSet)).setTaskCpuMap(this.taskAttributes.getTaskCPUMap(this.taskVertexSet));
    }

    public TaskSchedulePlan schedule(ComputeGraph computeGraph, WorkerPlan workerPlan) {
        this.taskVertexSet = computeGraph.getTaskVertexSet();
        TaskSchedulePlanBuilder taskSchedulePlanBuilder = this.newTaskSchedulingPlanBuilder(null);
        try {
            taskSchedulePlanBuilder = this.FirstFitFTaskSchedulingAlgorithm(taskSchedulePlanBuilder);
        }
        catch (TaskSchedulerException te) {
            throw new TaskSchedulerException("Couldn't allocate all instances to task schedule plan", (Throwable)te);
        }
        return taskSchedulePlanBuilder.build();
    }

    private TaskSchedulePlanBuilder FirstFitFTaskSchedulingAlgorithm(TaskSchedulePlanBuilder taskSchedulePlanBuilder) throws TaskSchedulerException {
        TreeSet<Vertex> orderedTaskSet = new TreeSet<Vertex>(new VertexComparator());
        orderedTaskSet.addAll(this.taskVertexSet);
        Map<String, Integer> parallelTaskMap = this.taskAttributes.getParallelTaskMap(this.taskVertexSet);
        this.assignInstancesToContainers(taskSchedulePlanBuilder, parallelTaskMap);
        return taskSchedulePlanBuilder;
    }

    private void assignInstancesToContainers(TaskSchedulePlanBuilder taskSchedulePlanBuilder, Map<String, Integer> parallelTaskMap) throws TaskSchedulerException {
        ArrayList<RequiredRam> ramRequirements = this.getSortedRAMInstances(parallelTaskMap.keySet());
        for (RequiredRam ramRequirement : ramRequirements) {
            String taskName = ramRequirement.getTaskName();
            int numberOfInstances = parallelTaskMap.get(taskName);
            for (int j = 0; j < numberOfInstances; ++j) {
                this.firstFitInstanceAllocation(taskSchedulePlanBuilder, taskName);
            }
        }
    }

    private ArrayList<RequiredRam> getSortedRAMInstances(Set<String> taskNameSet) {
        ArrayList<RequiredRam> ramRequirements = new ArrayList<RequiredRam>();
        TreeSet<Vertex> orderedTaskSet = new TreeSet<Vertex>(new VertexComparator());
        orderedTaskSet.addAll(this.taskVertexSet);
        Map<String, Double> taskRamMap = this.taskAttributes.getTaskRamMap(this.taskVertexSet);
        for (String taskName : taskNameSet) {
            Resource resource = TaskScheduleUtils.getResourceRequirement(taskName, taskRamMap, this.defaultResourceValue, this.maxContainerResourceValue, this.paddingPercentage);
            ramRequirements.add(new RequiredRam(taskName, resource.getRam()));
        }
        ramRequirements.sort(Collections.reverseOrder());
        return ramRequirements;
    }

    private void firstFitInstanceAllocation(TaskSchedulePlanBuilder taskSchedulePlanBuilder, String taskName) throws TaskSchedulerException {
        if (this.numContainers == 0) {
            taskSchedulePlanBuilder.updateNumContainers(++this.numContainers);
        }
        try {
            taskSchedulePlanBuilder.addInstance(new ContainerIdScorer(), taskName);
        }
        catch (TaskSchedulerException e) {
            taskSchedulePlanBuilder.updateNumContainers(++this.numContainers);
            taskSchedulePlanBuilder.addInstance(this.numContainers, taskName);
        }
    }

    private static class VertexComparator
    implements Comparator<Vertex> {
        private VertexComparator() {
        }

        @Override
        public int compare(Vertex o1, Vertex o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

