/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.http.OAuthAuthorization;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.media.AbstractImageUploadImpl;

class TwitpicUpload
extends AbstractImageUploadImpl {
    public TwitpicUpload(Configuration conf, String apiKey, OAuthAuthorization oauth) {
        super(conf, apiKey, oauth);
    }

    protected String postUpload() throws TwitterException {
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new TwitterException("Twitpic image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        try {
            JSONObject json = new JSONObject(response);
            if (!json.isNull("url")) {
                return json.getString("url");
            }
        }
        catch (JSONException e) {
            throw new TwitterException("Invalid Twitpic response: " + response, (Exception)((Object)e));
        }
        throw new TwitterException("Unknown Twitpic response", this.httpResponse);
    }

    protected void preUpload() throws TwitterException {
        this.uploadUrl = "https://twitpic.com/api/2/upload.json";
        String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader("https://api.twitter.com/1/account/verify_credentials.json");
        this.headers.put("X-Auth-Service-Provider", "https://api.twitter.com/1/account/verify_credentials.json");
        this.headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("key", this.apiKey), this.image};
        if (this.message != null) {
            params = this.appendHttpParameters(new HttpParameter[]{this.message}, params);
        }
        this.postParameter = params;
    }
}

