/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.screen;

import com.google.gwt.core.client.JavaScriptObject;
import elemental2.core.Map;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.uberfire.jsbridge.client.JsPlaceRequest;
import org.uberfire.jsbridge.client.loading.LazyLoadingScreen;

public class JsNativeScreen {
    private JavaScriptObject self;
    private final String componentId;
    private final HTMLElement container;
    private final Consumer<String> lazyLoadParentScript;
    private boolean loaded = false;
    private final Elemental2DomUtil elemental2DomUtil;

    public JsNativeScreen(String componentId, Consumer<String> lazyLoadParentScript, LazyLoadingScreen lazyScreen) {
        this.componentId = componentId;
        this.elemental2DomUtil = new Elemental2DomUtil();
        this.container = this.createContainerForLoadingScreen(lazyScreen.getElement());
        this.lazyLoadParentScript = lazyLoadParentScript;
    }

    public void updateRealContent(JavaScriptObject jsObject) {
        this.loaded = true;
        this.self = jsObject;
        this.elemental2DomUtil.removeAllElementChildren((Node)this.container);
    }

    public HTMLElement getElement() {
        return this.container;
    }

    public void render() {
        if (this.screenLoaded()) {
            this.renderNative();
        } else {
            this.lazyLoadParentScript.accept(this.componentId);
        }
    }

    public boolean screenLoaded() {
        return this.loaded;
    }

    private HTMLElement createContainerForLoadingScreen(HTMLElement loadingWidget) {
        HTMLElement container = (HTMLElement)DomGlobal.document.createElement("div");
        container.classList.add(new String[]{"js-screen-container"});
        container.appendChild((Node)loadingWidget);
        return container;
    }

    public String componentTitle() {
        String title = (String)this.get("af_componentTitle");
        return title != null ? title : this.getComponentId();
    }

    public String componentContextId() {
        return (String)this.get("af_componentContextId");
    }

    public Map<String, Object> subscriptions() {
        return (Map)Js.cast((Object)this.get("af_subscriptions"));
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void onStartup(JsPlaceRequest placeRequest) {
        this.run("af_onStartup", (Object)placeRequest);
    }

    public void onOpen() {
        this.run("af_onOpen");
    }

    public void onClose() {
        this.run("af_onClose");
        this.unmount();
    }

    public boolean onMayClose() {
        return !this.defines("af_onMayClose") || (Boolean)this.run("af_onMayClose") != false;
    }

    public void onShutdown() {
        this.run("af_onShutdown");
    }

    public void onFocus() {
        this.run("af_onFocus");
    }

    public void onLostFocus() {
        this.run("af_onLostFocus");
    }

    private Object get(String property) {
        if (!this.screenLoaded()) {
            return null;
        }
        return this.getNative(property);
    }

    private Object run(String functionName) {
        if (!this.screenLoaded()) {
            return null;
        }
        return this.runNative(functionName);
    }

    private Object run(String functionName, Object arg1) {
        if (!this.screenLoaded()) {
            return null;
        }
        return this.runNative(functionName, arg1);
    }

    public boolean defines(String property) {
        if (!this.screenLoaded()) {
            return false;
        }
        return this.definesNative(property);
    }

    private native Object getNative(String var1);

    private native Object runNative(String var1);

    private native Object runNative(String var1, Object var2);

    private native boolean definesNative(String var1);

    public native void renderNative();

    private native void unmount();
}

