/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.loading;

import com.google.common.base.Preconditions;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class AppFormerComponentsRegistry {
    public native String[] keys();

    public native JavaScriptObject get(String var1);

    public static class Entry {
        private final String componentId;
        private final JavaScriptObject self;

        public Entry(String componentId, JavaScriptObject self) {
            Preconditions.checkNotNull((Object)componentId);
            Preconditions.checkNotNull((Object)self);
            this.componentId = componentId;
            this.self = self;
        }

        JavaScriptObject getSelf() {
            return this.self;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public Type getType() {
            return Type.valueOf(((String)this.get("type")).toUpperCase());
        }

        public String getSource() {
            return (String)this.get("source");
        }

        public Map<String, String> getParams() {
            JavaScriptObject jsParams = (JavaScriptObject)this.get("params");
            if (jsParams == null) {
                return new HashMap<String, String>();
            }
            JSONObject json = new JSONObject(jsParams);
            return json.keySet().stream().filter(k -> json.get(k) != null).collect(Collectors.toMap(Function.identity(), k -> json.get(k).toString()));
        }

        private native Object get(String var1);

        public boolean matches(String uri) {
            String matches = this.getParams().get("matches");
            String regex = matches.substring(1, matches.length() - 1);
            return uri.matches(regex);
        }

        public static class EditorParams {
            private final Map<String, String> params;

            public EditorParams(Map<String, String> params) {
                this.params = params;
            }

            public Optional<String> matches() {
                return Optional.ofNullable(this.params.get("matches"));
            }
        }

        public static class PerspectiveParams {
            private final Map<String, String> params;

            public PerspectiveParams(Map<String, String> params) {
                this.params = params;
            }

            public Optional<Boolean> isDefault() {
                return Optional.ofNullable(this.params.get("is_default")).map(Boolean::valueOf);
            }
        }

        public static enum Type {
            PERSPECTIVE,
            SCREEN,
            EDITOR;

        }
    }
}

