/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.uberfire.commons.util.Preconditions;
import org.uberfire.commons.util.PreconditionsServer;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticatedStorageProvider;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.AuthenticationProvider;
import org.uberfire.security.auth.AuthenticationResult;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.AuthenticationStatus;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.server.HttpSecurityContext;

public class HttpAuthenticationManager
implements AuthenticationManager {
    private final List<AuthenticationScheme> authSchemes;
    private final List<AuthenticationProvider> authProviders;
    private final List<RoleProvider> roleProviders;
    private final List<AuthenticatedStorageProvider> authStorageProviders;
    private final ResourceManager resourceManager;
    private final ConcurrentHashMap<String, String> requestCache = new ConcurrentHashMap();

    public HttpAuthenticationManager(List<AuthenticationScheme> authScheme, List<AuthenticationProvider> authProviders, List<RoleProvider> roleProviders, List<AuthenticatedStorageProvider> authStorageProviders, ResourceManager resourceManager) {
        this.authSchemes = (List)Preconditions.checkNotEmpty((String)"authScheme", authScheme);
        this.authProviders = (List)Preconditions.checkNotEmpty((String)"authProviders", authProviders);
        this.roleProviders = (List)Preconditions.checkNotEmpty((String)"roleProviders", roleProviders);
        this.authStorageProviders = (List)Preconditions.checkNotEmpty((String)"authStorageProviders", authStorageProviders);
        this.resourceManager = (ResourceManager)Preconditions.checkNotNull((String)"resourceManager", (Object)resourceManager);
    }

    public Subject authenticate(SecurityContext context) throws AuthenticationException {
        AuthenticatedStorageProvider storeProvider;
        HttpSecurityContext httpContext = (HttpSecurityContext)PreconditionsServer.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        Principal principal = null;
        Iterator<AuthenticatedStorageProvider> i$ = this.authStorageProviders.iterator();
        while (i$.hasNext() && (principal = (storeProvider = i$.next()).load((SecurityContext)httpContext)) == null) {
        }
        if (principal != null && principal instanceof Subject) {
            return (Subject)principal;
        }
        boolean isRememberOp = principal != null;
        boolean requiresAuthentication = this.resourceManager.requiresAuthentication(httpContext.getResource());
        if (principal == null) {
            for (AuthenticationScheme authScheme : this.authSchemes) {
                if (authScheme.isAuthenticationRequest((SecurityContext)httpContext) || !requiresAuthentication) continue;
                this.requestCache.putIfAbsent(httpContext.getRequest().getSession().getId(), httpContext.getRequest().getRequestURI() + "?" + httpContext.getRequest().getQueryString());
                authScheme.challengeClient((SecurityContext)httpContext);
            }
            if (!requiresAuthentication) {
                return null;
            }
            block4: for (AuthenticationScheme authScheme : this.authSchemes) {
                Credential credential = authScheme.buildCredential((SecurityContext)httpContext);
                if (credential == null) continue;
                for (AuthenticationProvider authProvider : this.authProviders) {
                    AuthenticationResult result = authProvider.authenticate(credential);
                    if (result.getStatus().equals((Object)AuthenticationStatus.FAILED)) {
                        throw new AuthenticationException("Invalid credentials.");
                    }
                    if (!result.getStatus().equals((Object)AuthenticationStatus.SUCCESS)) continue;
                    principal = result.getPrincipal();
                    break block4;
                }
            }
        }
        if (principal == null) {
            throw new AuthenticationException("Invalid credentials.");
        }
        final ArrayList<1> roles = new ArrayList<1>();
        if (isRememberOp) {
            roles.add(new Role(){

                public String getName() {
                    return "IS_REMEMBER_ME";
                }
            });
        }
        for (RoleProvider roleProvider : this.roleProviders) {
            roles.addAll(roleProvider.loadRoles(principal));
        }
        final String name = principal.getName();
        Subject result = new Subject(){

            public List<Role> getRoles() {
                return roles;
            }

            public boolean hasRole(Role role) {
                Preconditions.checkNotNull((String)"role", (Object)role);
                for (Role activeRole : roles) {
                    if (!activeRole.getName().equals(role.getName())) continue;
                    return true;
                }
                return false;
            }

            public String getName() {
                return name;
            }
        };
        for (AuthenticatedStorageProvider storeProvider2 : this.authStorageProviders) {
            storeProvider2.store((SecurityContext)httpContext, result);
        }
        String originalRequest = this.requestCache.remove(httpContext.getRequest().getSession().getId());
        if (originalRequest != null && !originalRequest.isEmpty()) {
            try {
                httpContext.getResponse().sendRedirect(originalRequest);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to redirect.");
            }
        }
        return result;
    }

    public void logout(SecurityContext context) throws AuthenticationException {
        for (AuthenticatedStorageProvider storeProvider : this.authStorageProviders) {
            storeProvider.cleanup(context);
        }
    }
}

